/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.scout.rt.jackson.dataobject.DoDateSerializationHelper;
import org.eclipse.scout.rt.platform.util.LazyValue;

public class DoDateDeserializer
extends DateDeserializers.DateDeserializer {
    private static final long serialVersionUID = 1L;
    protected final LazyValue<DoDateSerializationHelper> m_helper = new LazyValue(DoDateSerializationHelper.class);

    public DoDateDeserializer() {
    }

    public DoDateDeserializer(DateDeserializers.DateDeserializer base, DateFormat df, String formatString) {
        super(base, df, formatString);
    }

    protected Date _parseDate(JsonParser p, DeserializationContext ctxt) throws IOException {
        SimpleDateFormat formatter = ((DoDateSerializationHelper)this.m_helper.get()).findFormatter(p.getParsingContext());
        if (formatter != null) {
            String str = p.getText().trim();
            if (str.isEmpty() || this._hasTextualNull(str)) {
                return (Date)this.getNullValue(ctxt);
            }
            try {
                return formatter.parse(str);
            }
            catch (ParseException e) {
                throw ctxt.weirdStringException(str, this.handledType(), "expected format [" + formatter.toPattern() + "]");
            }
        }
        return super._parseDate(p, ctxt);
    }

    protected DateDeserializers.DateDeserializer withDateFormat(DateFormat df, String formatString) {
        return new DoDateDeserializer(this, df, formatString);
    }
}

