/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;

public class DoBinaryResourceSerializer
extends StdSerializer<BinaryResource> {
    private static final long serialVersionUID = 1L;

    protected DoBinaryResourceSerializer() {
        super(BinaryResource.class);
    }

    public void serialize(BinaryResource br, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        this.writeNullsafeBinaryField(gen, "content", br.getContent());
        gen.writeNumberField("contentLength", br.getContentLength());
        gen.writeNumberField("lastModified", br.getLastModified());
        gen.writeStringField("contentType", br.getContentType());
        gen.writeStringField("filename", br.getFilename());
        gen.writeStringField("charset", br.getCharset());
        gen.writeNumberField("fingerprint", br.getFingerprint());
        gen.writeBooleanField("cachingAllowed", br.isCachingAllowed());
        gen.writeNumberField("cacheMaxAge", br.getCacheMaxAge());
        gen.writeEndObject();
    }

    protected void writeNullsafeBinaryField(JsonGenerator gen, String fieldName, byte[] data) throws IOException {
        if (data == null) {
            gen.writeNullField(fieldName);
        } else {
            gen.writeBinaryField(fieldName, data);
        }
    }
}

