/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import org.eclipse.scout.rt.jackson.dataobject.IDataObjectSerializerProvider;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;

@Bean
public class DataObjectSerializers
extends Serializers.Base {
    protected ScoutDataObjectModuleContext m_moduleContext;

    public DataObjectSerializers withModuleContext(ScoutDataObjectModuleContext moduleContext) {
        this.m_moduleContext = moduleContext;
        return this;
    }

    public ScoutDataObjectModuleContext getModuleContext() {
        return this.m_moduleContext;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonSerializer<?> serializer = provider.findSerializer(this.getModuleContext(), type, config, beanDesc);
            if (serializer == null) continue;
            return serializer;
        }
        return super.findSerializer(config, type, beanDesc);
    }

    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType refType, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonSerializer<?> serializer = provider.findReferenceSerializer(this.getModuleContext(), refType, config, beanDesc, contentTypeSerializer, contentValueSerializer);
            if (serializer == null) continue;
            return serializer;
        }
        return super.findReferenceSerializer(config, refType, beanDesc, contentTypeSerializer, contentValueSerializer);
    }

    public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonSerializer<?> serializer = provider.findCollectionSerializer(this.getModuleContext(), type, config, beanDesc, elementTypeSerializer, elementValueSerializer);
            if (serializer == null) continue;
            return serializer;
        }
        return super.findCollectionSerializer(config, type, beanDesc, elementTypeSerializer, elementValueSerializer);
    }
}

