/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import org.eclipse.scout.rt.jackson.dataobject.IDataObjectSerializerProvider;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;

@Bean
public class DataObjectDeserializers
extends Deserializers.Base {
    protected ScoutDataObjectModuleContext m_moduleContext;

    public DataObjectDeserializers withModuleContext(ScoutDataObjectModuleContext moduleContext) {
        this.m_moduleContext = moduleContext;
        return this;
    }

    public ScoutDataObjectModuleContext getModuleContext() {
        return this.m_moduleContext;
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonDeserializer<?> deserializer = provider.findDeserializer(this.getModuleContext(), type, config, beanDesc);
            if (deserializer == null) continue;
            return deserializer;
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) throws JsonMappingException {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonDeserializer<?> deserializer = provider.findReferenceDeserializer(this.getModuleContext(), refType, config, beanDesc, contentTypeDeserializer, contentDeserializer);
            if (deserializer == null) continue;
            return deserializer;
        }
        return super.findReferenceDeserializer(refType, config, beanDesc, contentTypeDeserializer, contentDeserializer);
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonDeserializer<?> deserializer = provider.findCollectionDeserializer(this.getModuleContext(), type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
            if (deserializer == null) continue;
            return deserializer;
        }
        return super.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        for (IDataObjectSerializerProvider provider : BEANS.all(IDataObjectSerializerProvider.class)) {
            JsonDeserializer<?> deserializer = provider.findEnumDeserializer(this.getModuleContext(), type, config, beanDesc);
            if (deserializer == null) continue;
            return deserializer;
        }
        return super.findEnumDeserializer(type, config, beanDesc);
    }
}

