/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;

public class DataObjectDeserializer
extends StdDeserializer<IDataObject> {
    private static final long serialVersionUID = 1L;

    public DataObjectDeserializer(Class<?> type) {
        super(type);
    }

    public IDataObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeDataObject(p, ctxt, null);
    }

    public IDataObject deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserializeDataObject(p, ctxt, typeDeserializer);
    }

    protected IDataObject deserializeDataObject(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        switch (p.currentToken()) {
            case START_OBJECT: {
                return (IDataObject)p.getCodec().readValue(p, IDoEntity.class);
            }
            case START_ARRAY: {
                return (IDataObject)p.getCodec().readValue(p, DoList.class);
            }
        }
        throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.START_OBJECT, "expected start object or start array token");
    }
}

