/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.uuidpool;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.scout.rt.client.uuidpool.IUuidPool;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;

public class UuidPool
extends AbstractPropertyObserver
implements IUuidPool {
    public UuidPool() {
        this(true);
    }

    public UuidPool(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        this.initConfig();
    }

    protected void initConfig() {
        this.setSize(this.getConfiguredSize());
        this.setRefillThreshold(this.getConfiguredRefillThreshold());
        this.setFailOnStarvation(this.getConfiguredFailOnStarvation());
    }

    protected int getConfiguredSize() {
        return 100;
    }

    protected int getConfiguredRefillThreshold() {
        return 25;
    }

    protected boolean getConfiguredFailOnStarvation() {
        return false;
    }

    @Override
    public int getSize() {
        return this.propertySupport.getPropertyInt("size");
    }

    @Override
    public void setSize(int size) {
        this.propertySupport.setPropertyInt("size", size);
    }

    @Override
    public int getRefillThreshold() {
        return this.propertySupport.getPropertyInt("refillThreshold");
    }

    @Override
    public void setRefillThreshold(int refillThreshold) {
        this.propertySupport.setPropertyInt("refillThreshold", refillThreshold);
    }

    @Override
    public boolean isFailOnStarvation() {
        return this.propertySupport.getPropertyBool("failOnStarvation");
    }

    @Override
    public void setFailOnStarvation(boolean failOnStarvation) {
        this.propertySupport.setPropertyBool("failOnStarvation", failOnStarvation);
    }

    @Override
    public List<UUID> generateUuids(int count) {
        return IntStream.range(0, count).mapToObj(i -> UUID.randomUUID()).collect(Collectors.toList());
    }
}

