/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.wizard.IWizardStepExtension;
import org.eclipse.scout.rt.client.extension.ui.wizard.WizardStepChains;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;

@ClassId(value="39d99aa9-002c-4367-9558-20225928fbd1")
public abstract class AbstractWizardStep<FORM extends IForm>
extends AbstractPropertyObserver
implements IWizardStep<FORM>,
IExtensibleObject {
    private static final String INITIALIZED = "INITIALIZED";
    private static final String ACTION_RUNNING = "ACTION_RUNNING";
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE"});
    private static final NamedBitMaskHelper ENABLED_BIT_HELPER = new NamedBitMaskHelper(new String[]{"ENABLED"});
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"INITIALIZED", "ACTION_RUNNING"});
    private IWizard m_wizard;
    private FORM m_form;
    private FormListener m_formListener;
    private int m_activationCounter;
    private final ObjectExtensions<AbstractWizardStep<FORM>, IWizardStepExtension<FORM, ? extends AbstractWizardStep<FORM>>> m_objectExtensions;
    private byte m_visible = (byte)-1;
    private byte m_enabled = (byte)-1;
    private byte m_flags;

    public AbstractWizardStep() {
        this(true);
    }

    public AbstractWizardStep(boolean callInitializer) {
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (this.isInitialized()) {
            return;
        }
        this.interceptInitConfig();
        this.setInitialized();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredSubTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=40.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    protected String getConfiguredCssClass() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=80.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredActionEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredFinished() {
        return false;
    }

    @Order(value=10.0)
    @ConfigOperation
    protected void execActivate(int stepKind) {
    }

    @Order(value=20.0)
    @ConfigOperation
    protected void execDeactivate(int stepKind) {
    }

    @Order(value=30.0)
    @ConfigOperation
    protected void execDispose() {
        FORM f = this.getForm();
        if (f != null) {
            f.doClose();
        }
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execFormStored(boolean activation) {
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execFormDiscarded(boolean activation) {
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execFormClosed(boolean activation) {
        if (!activation && this.getForm().isFormStored() && this.getForm().getCloseSystemType() != 1) {
            this.getWizard().doNextStep();
        }
    }

    @Order(value=70.0)
    @ConfigOperation
    protected void execAction() {
        if (this.getWizard() != null) {
            this.getWizard().doStepAction(this);
        }
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IWizardStep.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        this.setTitle(this.getConfiguredTitle());
        this.setSubTitle(this.getConfiguredSubTitle());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setIconId(this.getConfiguredIconId());
        this.setEnabled(this.getConfiguredEnabled());
        this.setVisible(this.getConfiguredVisible());
        this.setCssClass(this.getConfiguredCssClass());
        this.setOrder(this.calculateViewOrder());
        this.setActionEnabled(this.getConfiguredActionEnabled());
        this.setFinished(this.getConfiguredFinished());
    }

    protected IWizardStepExtension<FORM, ? extends AbstractWizardStep<FORM>> createLocalExtension() {
        return new LocalWizardStepExtension(this);
    }

    public final List<? extends IWizardStepExtension<FORM, ? extends AbstractWizardStep<FORM>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @Override
    public FORM getForm() {
        return this.m_form;
    }

    @Override
    public void setForm(FORM f) {
        if (this.m_form != null && this.m_formListener != null) {
            this.m_form.removeFormListener(this.m_formListener, new Integer[0]);
        }
        this.m_form = f;
        if (this.m_form != null) {
            if (this.m_formListener == null) {
                this.m_formListener = e -> {
                    try {
                        switch (e.getType()) {
                            case 2020: {
                                this.interceptFormStored(this.m_activationCounter > 0);
                                break;
                            }
                            case 3000: {
                                this.interceptFormDiscarded(this.m_activationCounter > 0);
                                break;
                            }
                            case 3010: {
                                this.interceptFormClosed(this.m_activationCounter > 0);
                            }
                        }
                    }
                    catch (Exception pe) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)pe);
                    }
                    switch (e.getType()) {
                        case 3010: {
                            if (f != this.m_form) break;
                            this.setForm(null);
                        }
                    }
                };
            }
            this.m_form.addFormListener(this.m_formListener, new Integer[0]);
        }
    }

    @Override
    public IWizard getWizard() {
        return this.m_wizard;
    }

    @Override
    public void setWizardInternal(IWizard w) {
        this.m_wizard = w;
    }

    private boolean isInitialized() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALIZED, this.m_flags);
    }

    private void setInitialized() {
        this.m_flags = FLAGS_BIT_HELPER.setBit(INITIALIZED, this.m_flags);
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String title) {
        this.propertySupport.setPropertyString("title", title);
    }

    @Override
    public String getSubTitle() {
        return this.propertySupport.getPropertyString("subTitle");
    }

    @Override
    public void setSubTitle(String subTitle) {
        this.propertySupport.setPropertyString("subTitle", subTitle);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String tooltipText) {
        this.propertySupport.setPropertyString("tooltipText", tooltipText);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, "ENABLED");
    }

    public void setEnabled(boolean enabled, String dimension) {
        this.m_enabled = ENABLED_BIT_HELPER.changeBit(dimension, enabled, this.m_enabled);
        this.setEnabledInternal();
    }

    public boolean isEnabled(String dimension) {
        return ENABLED_BIT_HELPER.isBitSet(dimension, this.m_enabled);
    }

    private void setEnabledInternal() {
        this.propertySupport.setPropertyBool("enabled", NamedBitMaskHelper.allBitsSet((byte)this.m_enabled));
    }

    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.setVisibleInternal();
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, "VISIBLE");
    }

    private void setVisibleInternal() {
        this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet((byte)this.m_visible));
    }

    @Override
    public boolean isActionEnabled() {
        return this.propertySupport.getPropertyBool("actionEnabled");
    }

    @Override
    public void setActionEnabled(boolean actionEnabled) {
        this.propertySupport.setPropertyBool("actionEnabled", actionEnabled);
    }

    @Override
    public String getCssClass() {
        return this.propertySupport.getPropertyString("cssClass");
    }

    @Override
    public void setCssClass(String cssClass) {
        this.propertySupport.setPropertyString("cssClass", cssClass);
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @Override
    public boolean isFinished() {
        return this.propertySupport.getPropertyBool("finished");
    }

    @Override
    public void setFinished(boolean isFinished) {
        this.propertySupport.setPropertyBool("finished", isFinished);
    }

    @Override
    public void activate(int stepKind) {
        try {
            ++this.m_activationCounter;
            this.interceptActivate(stepKind);
        }
        finally {
            --this.m_activationCounter;
        }
    }

    @Override
    public void deactivate(int stepKind) {
        try {
            ++this.m_activationCounter;
            this.interceptDeactivate(stepKind);
        }
        finally {
            --this.m_activationCounter;
        }
    }

    @Override
    public void dispose() {
        try {
            ++this.m_activationCounter;
            this.interceptDispose();
        }
        finally {
            --this.m_activationCounter;
        }
    }

    protected boolean isPerformingWizardStepAction() {
        return FLAGS_BIT_HELPER.isBitSet(ACTION_RUNNING, this.m_flags);
    }

    protected void setPerformingWizardStepAction(boolean performingWizardStepAction) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ACTION_RUNNING, performingWizardStepAction, this.m_flags);
    }

    @Override
    public void doAction() {
        if (this.isActionEnabled() && !this.isPerformingWizardStepAction()) {
            try {
                this.setPerformingWizardStepAction(true);
                this.interceptAction();
            }
            finally {
                this.setPerformingWizardStepAction(false);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getTitle() + "]";
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    protected final void interceptDeactivate(int stepKind) {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepDeactivateChain<FORM> chain = new WizardStepChains.WizardStepDeactivateChain<FORM>(extensions);
        chain.execDeactivate(stepKind);
    }

    protected final void interceptDispose() {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepDisposeChain<FORM> chain = new WizardStepChains.WizardStepDisposeChain<FORM>(extensions);
        chain.execDispose();
    }

    protected final void interceptFormClosed(boolean activation) {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepFormClosedChain<FORM> chain = new WizardStepChains.WizardStepFormClosedChain<FORM>(extensions);
        chain.execFormClosed(activation);
    }

    protected final void interceptActivate(int stepKind) {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepActivateChain<FORM> chain = new WizardStepChains.WizardStepActivateChain<FORM>(extensions);
        chain.execActivate(stepKind);
    }

    protected final void interceptFormDiscarded(boolean activation) {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepFormDiscardedChain<FORM> chain = new WizardStepChains.WizardStepFormDiscardedChain<FORM>(extensions);
        chain.execFormDiscarded(activation);
    }

    protected final void interceptFormStored(boolean activation) {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepFormStoredChain<FORM> chain = new WizardStepChains.WizardStepFormStoredChain<FORM>(extensions);
        chain.execFormStored(activation);
    }

    protected final void interceptAction() {
        List<IWizardStepExtension<FORM, AbstractWizardStep<FORM>>> extensions = this.getAllExtensions();
        WizardStepChains.WizardStepActionChain<FORM> chain = new WizardStepChains.WizardStepActionChain<FORM>(extensions);
        chain.execAction();
    }

    protected static class LocalWizardStepExtension<FORM extends IForm, OWNER extends AbstractWizardStep<FORM>>
    extends AbstractExtension<OWNER>
    implements IWizardStepExtension<FORM, OWNER> {
        public LocalWizardStepExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDeactivate(WizardStepChains.WizardStepDeactivateChain<? extends IForm> chain, int stepKind) {
            ((AbstractWizardStep)this.getOwner()).execDeactivate(stepKind);
        }

        @Override
        public void execDispose(WizardStepChains.WizardStepDisposeChain<? extends IForm> chain) {
            ((AbstractWizardStep)this.getOwner()).execDispose();
        }

        @Override
        public void execFormClosed(WizardStepChains.WizardStepFormClosedChain<? extends IForm> chain, boolean activation) {
            ((AbstractWizardStep)this.getOwner()).execFormClosed(activation);
        }

        @Override
        public void execActivate(WizardStepChains.WizardStepActivateChain<? extends IForm> chain, int stepKind) {
            ((AbstractWizardStep)this.getOwner()).execActivate(stepKind);
        }

        @Override
        public void execFormDiscarded(WizardStepChains.WizardStepFormDiscardedChain<? extends IForm> chain, boolean activation) {
            ((AbstractWizardStep)this.getOwner()).execFormDiscarded(activation);
        }

        @Override
        public void execFormStored(WizardStepChains.WizardStepFormStoredChain<? extends IForm> chain, boolean activation) {
            ((AbstractWizardStep)this.getOwner()).execFormStored(activation);
        }

        @Override
        public void execAction(WizardStepChains.WizardStepActionChain<? extends IForm> chain) {
            ((AbstractWizardStep)this.getOwner()).execAction();
        }
    }
}

