/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.eclipse.scout.rt.client.extension.ui.wizard.IWizardContainerFormExtension;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardAction;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;

@ClassId(value="c2e405b4-be26-4d27-b379-06ec62793d84")
public abstract class AbstractWizardContainerForm
extends AbstractForm
implements IWizardContainerForm {
    private final IWizard m_wizard;
    private P_WizardPropertyListener m_propertyChangeListener;

    public AbstractWizardContainerForm(IWizard wizard) {
        this(wizard, true);
    }

    public AbstractWizardContainerForm(IWizard wizard, boolean callInitializer) {
        super(false);
        this.m_wizard = wizard;
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    public IWizard getWizard() {
        return this.m_wizard;
    }

    @Override
    protected boolean getConfiguredMaximizeEnabled() {
        return true;
    }

    @Override
    protected void execInitForm() {
        if (this.m_wizard != null) {
            if (this.m_propertyChangeListener == null) {
                this.m_propertyChangeListener = new P_WizardPropertyListener();
            }
            this.m_wizard.addPropertyChangeListener(this.m_propertyChangeListener);
        }
        this.updateTitleFromWizard(false);
    }

    @Override
    protected void execDisposeForm() {
        if (this.m_wizard != null && this.m_propertyChangeListener != null) {
            this.m_wizard.removePropertyChangeListener(this.m_propertyChangeListener);
            this.m_propertyChangeListener = null;
        }
        super.doFinally();
    }

    @Override
    protected void execOnCloseRequest(boolean kill, Set<Integer> enabledButtonSystemTypes) {
        this.handleEscapeKey(kill);
    }

    protected void handleEscapeKey(boolean kill) {
        IWizardAction action = this.getEscapeAction(kill);
        if (action instanceof IAction) {
            ((IAction)((Object)action)).doAction();
        } else if (action instanceof IButton) {
            ((IButton)((Object)action)).doClick();
        } else {
            this.getWizard().doCancel();
        }
    }

    protected void handleEnterKey() {
        IWizardAction action = this.getEnterAction();
        if (action instanceof IAction) {
            ((IAction)((Object)action)).doAction();
        } else if (action instanceof IButton) {
            ((IButton)((Object)action)).doClick();
        }
    }

    protected IWizardAction getEscapeAction(boolean kill) {
        if (kill) {
            if (this.getWizardSuspendButton() != null && this.getWizardSuspendButton().isVisible() && this.getWizardSuspendButton().isEnabled()) {
                return this.getWizardSuspendButton();
            }
            if (this.getWizardCancelButton() != null && this.getWizardCancelButton().isVisible() && this.getWizardCancelButton().isEnabled()) {
                return this.getWizardCancelButton();
            }
            return null;
        }
        if (this.getWizardCancelButton() != null && this.getWizardCancelButton().isVisible() && this.getWizardCancelButton().isEnabled()) {
            return this.getWizardCancelButton();
        }
        if (this.getWizardSuspendButton() != null && this.getWizardSuspendButton().isVisible() && this.getWizardSuspendButton().isEnabled()) {
            return this.getWizardSuspendButton();
        }
        return null;
    }

    protected IWizardAction getEnterAction() {
        if (this.getWizardNextStepButton() != null && this.getWizardNextStepButton().isVisible() && this.getWizardNextStepButton().isEnabled()) {
            return this.getWizardNextStepButton();
        }
        if (this.getWizardFinishButton() != null && this.getWizardFinishButton().isVisible() && this.getWizardFinishButton().isEnabled()) {
            return this.getWizardFinishButton();
        }
        return null;
    }

    protected void updateTitleFromWizard(boolean force) {
        if (this.getWizard() != null) {
            String title = this.getWizard().getTitle();
            String subTitle = this.getWizard().getSubTitle();
            if (title != null || force) {
                this.setTitle(title);
            }
            if (subTitle != null || force) {
                this.setSubTitle(subTitle);
            }
        }
    }

    protected abstract IForm getInnerWizardForm();

    protected abstract void setInnerWizardForm(IForm var1);

    protected void handleWizardPropertyChanged(String propertyName, Object oldValue, Object newValue) {
        try {
            if ("wizardForm".equals(propertyName)) {
                this.setInnerWizardForm(this.getWizard().getWizardForm());
            } else if ("title".equals(propertyName)) {
                this.updateTitleFromWizard(true);
            } else if ("subTitle".equals(propertyName)) {
                this.updateTitleFromWizard(true);
            }
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    protected IWizardContainerFormExtension<? extends AbstractWizardContainerForm> createLocalExtension() {
        return new LocalWizardContainerFormExtension<AbstractWizardContainerForm>(this);
    }

    protected static class LocalWizardContainerFormExtension<OWNER extends AbstractWizardContainerForm>
    extends AbstractForm.LocalFormExtension<OWNER>
    implements IWizardContainerFormExtension<OWNER> {
        public LocalWizardContainerFormExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_WizardPropertyListener
    implements PropertyChangeListener {
        private P_WizardPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractWizardContainerForm.this.handleWizardPropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

