/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.wizard.IWizardExtension;
import org.eclipse.scout.rt.client.extension.ui.wizard.WizardChains;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.wizard.DefaultWizardContainerForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardAction;
import org.eclipse.scout.rt.client.ui.wizard.IWizardContainerForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.client.ui.wizard.WizardEvent;
import org.eclipse.scout.rt.client.ui.wizard.WizardListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="d9f41936-b7c1-4635-b769-f7999dd5eb0d")
public abstract class AbstractWizard
extends AbstractPropertyObserver
implements IWizard,
IContributionOwner,
IExtensibleObject {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWizard.class);
    private boolean m_initialized;
    private final FastListenerList<WizardListener> m_listenerList = new FastListenerList();
    private List<IWizardStep<? extends IForm>> m_availableStepList;
    private List<IWizardStep<? extends IForm>> m_stepList;
    private IWizardStep<? extends IForm> m_activeStep;
    private final OptimisticLock m_changingLock = new OptimisticLock();
    private List<WizardEvent> m_accumulatedEvents = new ArrayList<WizardEvent>(3);
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractWizard, IWizardExtension<? extends AbstractWizard>> m_objectExtensions;
    private final IBlockingCondition m_blockingCondition;
    private IWizardContainerForm m_containerForm;
    private PropertyChangeListener m_anyFieldChangeListener;
    private FormListener m_containerFormListener;

    public AbstractWizard() {
        this(true);
    }

    public AbstractWizard(boolean callInitializer) {
        this.m_availableStepList = new ArrayList<IWizardStep<? extends IForm>>(0);
        this.m_stepList = new ArrayList<IWizardStep<? extends IForm>>(0);
        this.m_blockingCondition = Jobs.newBlockingCondition((boolean)false);
        this.m_objectExtensions = new ObjectExtensions((Object)this, true);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredSubTitle() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredManagedByContainerForm() {
        return true;
    }

    private List<Class<? extends IWizardStep<? extends IForm>>> getConfiguredAvailableSteps() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IWizardStep.class);
        ArrayList<Class<? extends IWizardStep<? extends IForm>>> result = new ArrayList<Class<? extends IWizardStep<? extends IForm>>>(filtered.size());
        for (Class wizardStep : filtered) {
            result.add(wizardStep);
        }
        return result;
    }

    @ConfigOperation
    @Order(value=5.0)
    protected IWizardContainerForm execCreateContainerForm() {
        return new DefaultWizardContainerForm(this);
    }

    protected void execDecorateContainerForm() {
    }

    @ConfigOperation
    @Order(value=6.0)
    protected void execActiveStepChanged() {
    }

    @Order(value=10.0)
    @ConfigOperation
    protected void execStart() {
        List<IWizardStep<? extends IForm>> steps = this.getAvailableSteps();
        this.setSteps(steps);
        if (!steps.isEmpty()) {
            this.activateStep(steps.get(0));
        }
    }

    @Order(value=15.0)
    @ConfigOperation
    protected void execPostStart() {
    }

    @Order(value=20.0)
    @ConfigOperation
    protected void execNextStep() {
        IWizardStep<? extends IForm> step = this.getNextStep();
        this.activateStep(step);
    }

    @Order(value=30.0)
    @ConfigOperation
    protected void execPreviousStep() {
        IWizardStep<? extends IForm> step = this.getPreviousStep();
        this.activateStep(step);
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execFinish() {
        this.activateStep(null);
        this.close();
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execCancel() {
        this.close();
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execSuspend() {
        this.close();
    }

    @Order(value=65.0)
    @ConfigOperation
    protected void execReset() {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execAnyFieldChanged(IFormField source) {
    }

    @ConfigOperation
    @Order(value=75.0)
    protected void execContainerFormClosed() {
        this.close();
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execRefreshButtonPolicy() {
        IWizardStep<? extends IForm> prev = this.getPreviousStep();
        IWizardStep<? extends IForm> next = this.getNextStep();
        IWizardAction action = this.getContainerForm().getWizardPreviousStepButton();
        if (action != null) {
            action.setView(true, prev != null);
        }
        if ((action = this.getContainerForm().getWizardNextStepButton()) != null) {
            action.setView(next != null, true);
        }
        if ((action = this.getContainerForm().getWizardFinishButton()) != null) {
            action.setView(next == null, true);
        }
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execAppLinkAction(String ref) {
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execStepAction(IWizardStep<? extends IForm> step) {
        int stepKind = this.getStepKind(this.getActiveStep(), step);
        this.activateStep(step, stepKind == 1, stepKind == 2);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        this.setTitle(this.getConfiguredTitle());
        this.setSubTitle(this.getConfiguredSubTitle());
        this.setManagedByContainerForm(this.getConfiguredManagedByContainerForm());
        this.setClosedInternal(true);
        this.setCloseTypeInternal(IWizard.CloseType.Unknown);
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.m_containerForm = this.createContainerForm();
        Assertions.assertNotNull((Object)this.m_containerForm, (String)"Missing container form", (Object[])new Object[0]);
        this.interceptDecorateContainerForm();
        if (this.isManagedByContainerForm()) {
            this.m_containerFormListener = this::handleContainerFormEvent;
            this.m_containerForm.addFormListener(this.m_containerFormListener, new Integer[0]);
        }
        this.runWithinContainerForm(() -> {
            List<Class<? extends IWizardStep<? extends IForm>>> configuredAvailableSteps = this.getConfiguredAvailableSteps();
            List contributedSteps = this.m_contributionHolder.getContributionsByClass(IWizardStep.class);
            OrderedCollection steps = new OrderedCollection();
            for (Class<? extends IWizardStep<? extends IForm>> element : configuredAvailableSteps) {
                IWizardStep step = (IWizardStep)ConfigurationUtility.newInnerInstance((Object)this, element);
                steps.addOrdered((IOrdered)step);
            }
            for (IWizardStep step : contributedSteps) {
                steps.addOrdered((IOrdered)step);
            }
            this.injectStepsInternal((OrderedCollection<IWizardStep<? extends IForm>>)steps);
            ExtensionUtility.moveModelObjects((Iterable)steps);
            this.setAvailableSteps(steps.getOrderedList());
            this.m_anyFieldChangeListener = e -> {
                try {
                    this.interceptAnyFieldChanged((IFormField)e.getSource());
                }
                catch (RuntimeException | PlatformError t) {
                    LOG.error("{} {}={}", new Object[]{e.getSource(), e.getPropertyName(), e.getNewValue(), t});
                }
            };
            this.propertySupport.addPropertyChangeListener("wizardForm", e -> {
                IForm oldForm = (IForm)e.getOldValue();
                IForm newForm = (IForm)e.getNewValue();
                if (oldForm != null) {
                    oldForm.getRootGroupBox().removeSubtreePropertyChangeListener("value", this.m_anyFieldChangeListener);
                }
                if (newForm != null) {
                    newForm.getRootGroupBox().addSubtreePropertyChangeListener("value", this.m_anyFieldChangeListener);
                }
            });
        });
    }

    protected void handleContainerFormEvent(FormEvent e) {
        if (e.getType() == 3010) {
            this.m_containerForm.removeFormListener(this.m_containerFormListener, new Integer[0]);
            this.m_containerFormListener = null;
            this.interceptContainerFormClosed();
        }
    }

    protected IWizardExtension<? extends AbstractWizard> createLocalExtension() {
        return new LocalWizardExtension<AbstractWizard>(this);
    }

    public final List<? extends IWizardExtension<? extends AbstractWizard>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectStepsInternal(OrderedCollection<IWizardStep<? extends IForm>> steps) {
    }

    @Override
    public IFastListenerList<WizardListener> wizardListeners() {
        return this.m_listenerList;
    }

    private void fireStateChanged() {
        this.fireWizardEvent(new WizardEvent(this, 10));
    }

    private void fireClosed() {
        this.fireWizardEvent(new WizardEvent(this, 50));
    }

    private void fireWizardEvent(WizardEvent e) {
        if (this.m_changingLock.isAcquired()) {
            this.m_accumulatedEvents.removeIf(existingEvent -> existingEvent.getType() == e.getType());
            this.m_accumulatedEvents.add(e);
        } else {
            this.wizardListeners().list().forEach(listener -> listener.wizardChanged(e));
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String title) {
        this.propertySupport.setPropertyString("title", title);
    }

    @Override
    public String getSubTitle() {
        return this.propertySupport.getPropertyString("subTitle");
    }

    @Override
    public void setSubTitle(String subTitle) {
        this.propertySupport.setPropertyString("subTitle", subTitle);
    }

    @Override
    public boolean isManagedByContainerForm() {
        return this.propertySupport.getPropertyBool("managedByContainerForm");
    }

    private void setManagedByContainerForm(boolean managedByContainerForm) {
        this.propertySupport.setPropertyBool("managedByContainerForm", managedByContainerForm);
    }

    @Override
    public void setChanging(boolean changing) {
        if (changing) {
            this.m_changingLock.acquire();
        } else {
            this.m_changingLock.release();
            if (this.m_changingLock.isReleased()) {
                List<WizardEvent> list = this.m_accumulatedEvents;
                this.m_accumulatedEvents = new ArrayList<WizardEvent>(3);
                for (WizardEvent e : list) {
                    this.fireWizardEvent(e);
                }
            }
        }
    }

    @Override
    public boolean isChanging() {
        return this.m_changingLock.isAcquired();
    }

    @Override
    public IDesktop getDesktop() {
        if (ClientSessionProvider.currentSession() != null) {
            return ClientSessionProvider.currentSession().getDesktop();
        }
        return null;
    }

    @Override
    public <T extends IWizardStep<? extends IForm>> T getAvailableStep(Class<T> type) {
        for (IWizardStep<? extends IForm> step : this.m_availableStepList) {
            if (!type.isInstance(step)) continue;
            return (T)step;
        }
        return null;
    }

    @Override
    public <T extends IWizardStep<? extends IForm>> T getStep(Class<T> type) {
        for (IWizardStep<? extends IForm> step : this.m_stepList) {
            if (!type.isInstance(step)) continue;
            return (T)step;
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getStep(int index) {
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getStepBySimpleClassName(String simpleClassName) {
        for (IWizardStep<? extends IForm> step : this.m_stepList) {
            if (!step.getClass().getSimpleName().equals(simpleClassName)) continue;
            return step;
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getStepByClassName(String className) {
        for (IWizardStep<? extends IForm> step : this.m_stepList) {
            if (!step.getClass().getName().equals(className)) continue;
            return step;
        }
        return null;
    }

    @Override
    public int getStepIndex(IWizardStep<? extends IForm> step) {
        if (step == null) {
            return -1;
        }
        int i = 0;
        while (i < this.m_stepList.size()) {
            if (this.m_stepList.get(i).equals(step)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<IWizardStep<? extends IForm>> getAvailableSteps() {
        return CollectionUtility.arrayList(this.m_availableStepList);
    }

    @Override
    public void setAvailableSteps(List<IWizardStep<? extends IForm>> steps) {
        this.m_availableStepList = new ArrayList<IWizardStep<? extends IForm>>();
        if (steps != null) {
            for (IWizardStep<? extends IForm> step : steps) {
                if (step == null) continue;
                this.m_availableStepList.add(step);
            }
        }
    }

    @Override
    public List<IWizardStep<? extends IForm>> getSteps() {
        return CollectionUtility.arrayList(this.m_stepList);
    }

    @Override
    public void setSteps(IWizardStep<?> ... steps) {
        if (steps == null) {
            steps = new IWizardStep[]{};
        }
        this.setSteps(Arrays.asList(steps));
    }

    @Override
    public void setSteps(List<IWizardStep<? extends IForm>> steps) {
        try {
            this.setChanging(true);
            if (this.m_stepList != null) {
                for (IWizardStep<? extends IForm> step : this.m_stepList) {
                    step.setWizardInternal(null);
                }
            }
            this.m_stepList = new ArrayList<IWizardStep<? extends IForm>>();
            if (steps != null) {
                for (IWizardStep<? extends IForm> step : steps) {
                    if (step == null) continue;
                    this.m_stepList.add(step);
                    step.setWizardInternal(this);
                }
            }
            this.fireStateChanged();
        }
        finally {
            this.setChanging(false);
        }
    }

    @Override
    public IWizardStep<? extends IForm> getActiveStep() {
        return this.m_activeStep;
    }

    protected void setActiveStepInternal(IWizardStep<? extends IForm> activeStep) {
        this.m_activeStep = activeStep;
    }

    @Override
    public void activateStep(IWizardStep<? extends IForm> step) {
        this.activateStep(step, false, false);
    }

    @Override
    public void activateStep(IWizardStep<? extends IForm> targetStep, boolean jumpForward, boolean jumpBackward) {
        if (this.m_activeStep == targetStep) {
            return;
        }
        int kind = this.getStepKind(this.m_activeStep, targetStep);
        boolean skipIntermediateSteps = kind == 1 && jumpForward || kind == 2 && jumpBackward;
        List<IWizardStep<? extends IForm>> steps = !skipIntermediateSteps ? this.getStepSpan(this.m_activeStep, false, targetStep, true) : Collections.singletonList(targetStep);
        try {
            for (IWizardStep<? extends IForm> step : steps) {
                this.activateStepInternal(step, kind);
            }
        }
        finally {
            this.refreshButtonPolicy();
            this.fireStateChanged();
        }
    }

    protected void activateStepInternal(IWizardStep<? extends IForm> step, int kind) {
        if (this.m_activeStep != null) {
            this.m_activeStep.deactivate(kind);
        }
        IWizardStep<? extends IForm> lastStep = this.m_activeStep;
        this.m_activeStep = step;
        if (this.m_activeStep != null) {
            try {
                this.m_activeStep.activate(kind);
            }
            catch (RuntimeException e) {
                this.m_activeStep = lastStep;
                if (lastStep != null) {
                    try {
                        int stepKindInverted = kind == 1 ? 2 : 1;
                        lastStep.activate(stepKindInverted);
                    }
                    catch (RuntimeException innerException) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)innerException);
                    }
                }
                throw e;
            }
        }
        try {
            this.interceptActiveStepChanged();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
    }

    @Override
    public void refreshButtonPolicy() {
        try {
            this.interceptRefreshButtonPolicy();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
    }

    @Override
    public int getStepKind(IWizardStep<? extends IForm> from, IWizardStep<? extends IForm> to) {
        int toIndex;
        if (from == null && to == null) {
            return 1;
        }
        if (from == null) {
            return 1;
        }
        if (to == null) {
            return 1;
        }
        int fromIndex = this.getStepIndex(from);
        if (fromIndex == (toIndex = this.getStepIndex(to))) {
            return 1;
        }
        if (fromIndex < toIndex) {
            return 1;
        }
        return 2;
    }

    @Override
    public List<IWizardStep<? extends IForm>> getStepSpan(IWizardStep<? extends IForm> from, boolean includeFrom, IWizardStep<? extends IForm> to, boolean includeTo) {
        ArrayList<IWizardStep<? extends IForm>> list = new ArrayList<IWizardStep<? extends IForm>>();
        if (includeFrom) {
            list.add(from);
        }
        if (from != null && to != null) {
            int i;
            int n;
            int toIndex;
            int fromIndex = this.getStepIndex(from);
            if (fromIndex < (toIndex = this.getStepIndex(to)) - 1) {
                n = toIndex - fromIndex - 1;
                i = 0;
                while (i < n) {
                    list.add(this.m_stepList.get(fromIndex + 1 + i));
                    ++i;
                }
            }
            if (fromIndex > toIndex + 1) {
                n = fromIndex - toIndex - 1;
                i = 0;
                while (i < n) {
                    list.add(this.m_stepList.get(fromIndex - 1 - i));
                    ++i;
                }
            }
        }
        if (includeTo) {
            list.add(to);
        }
        return list;
    }

    @Override
    public IWizardStep<? extends IForm> getPreviousStep() {
        int index = this.getStepIndex(this.getActiveStep()) - 1;
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getNextStep() {
        int index = this.getStepIndex(this.getActiveStep()) + 1;
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getPreviousEnabledStep() {
        int index = this.getStepIndex(this.getActiveStep()) - 1;
        while (index >= 0 && index < this.m_stepList.size() && !this.m_stepList.get(index).isEnabled()) {
            --index;
        }
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    @Override
    public IWizardStep<? extends IForm> getNextEnabledStep() {
        int index = this.getStepIndex(this.getActiveStep()) + 1;
        while (index >= 0 && index < this.m_stepList.size() && !this.m_stepList.get(index).isEnabled()) {
            ++index;
        }
        if (index >= 0 && index < this.m_stepList.size()) {
            return this.m_stepList.get(index);
        }
        return null;
    }

    public List<IWizardStep<? extends IForm>> getHistory() {
        int index = this.getStepIndex(this.getActiveStep());
        if (!this.m_stepList.isEmpty() && index >= 0) {
            return CollectionUtility.arrayList(this.m_stepList.subList(0, Math.min(index, this.m_stepList.size())));
        }
        return CollectionUtility.emptyArrayList();
    }

    public List<IWizardStep<? extends IForm>> getExpectedFuture() {
        int index = this.getStepIndex(this.getActiveStep());
        if (!this.m_stepList.isEmpty() && index < this.m_stepList.size()) {
            return CollectionUtility.arrayList(this.m_stepList.subList(Math.max(index + 1, 0), this.m_stepList.size()));
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public void start() {
        this.assertClosed();
        if (this.m_blockingCondition.isBlocking()) {
            throw new ProcessingException("The wizard " + this.getClass().getSimpleName() + " has already been started", new Object[0]);
        }
        this.m_blockingCondition.setBlocking(true);
        this.setClosedInternal(false);
        this.setCloseTypeInternal(IWizard.CloseType.Unknown);
        this.runWithinContainerForm(() -> {
            this.interceptStart();
            if (this.m_containerForm.isFormStartable()) {
                this.m_containerForm.startWizard();
            }
            this.interceptPostStart();
        });
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            try {
                if (this.m_containerForm != null) {
                    if (this.m_containerFormListener != null) {
                        this.m_containerForm.removeFormListener(this.m_containerFormListener, new Integer[0]);
                        this.m_containerFormListener = null;
                    }
                    if (!this.m_containerForm.isFormClosed()) {
                        this.m_containerForm.doClose();
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.error("Unexpected error while closing container form: {}", (Object)this.m_containerForm, (Object)e);
            }
            HashSet<IWizardStep<? extends IForm>> set = new HashSet<IWizardStep<? extends IForm>>();
            set.addAll(this.getAvailableSteps());
            set.addAll(this.getSteps());
            for (IWizardStep iWizardStep : set) {
                try {
                    iWizardStep.dispose();
                }
                catch (RuntimeException t) {
                    LOG.error("Unexpected error while disposing step: {}", (Object)iWizardStep, (Object)t);
                }
            }
            if (this.getCloseType() == IWizard.CloseType.Unknown) {
                this.setCloseTypeInternal(IWizard.CloseType.Closed);
            }
            this.setClosedInternal(true);
            this.fireClosed();
            this.m_blockingCondition.setBlocking(false);
        }
    }

    @Override
    public void waitFor() {
        IDesktop desktop = this.getDesktop();
        if (desktop == null || !desktop.isOpened()) {
            throw new ProcessingException("Cannot wait for {}. No desktop found, or the desktop is not opened in the UI yet.", new Object[]{this.getClass().getName()}).withCode(69218);
        }
        this.m_blockingCondition.waitFor(new String[]{"ui.interaction.required"});
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed();
    }

    @Override
    public boolean isClosed() {
        return this.propertySupport.getPropertyBool("closed");
    }

    protected void setClosedInternal(boolean closed) {
        this.propertySupport.setProperty("closed", (Object)closed);
    }

    @Override
    public IWizard.CloseType getCloseType() {
        return (IWizard.CloseType)((Object)this.propertySupport.getProperty("closeType"));
    }

    protected void setCloseTypeInternal(IWizard.CloseType t) {
        this.propertySupport.setProperty("closeType", (Object)t);
    }

    @Override
    public void doNextStep() {
        if (this.isOpen()) {
            this.runWithinContainerForm(this::interceptNextStep);
        }
    }

    @Override
    public void doPreviousStep() {
        if (this.isOpen()) {
            this.runWithinContainerForm(this::interceptPreviousStep);
        }
    }

    @Override
    public void doFinish() {
        if (this.isOpen()) {
            this.runWithinContainerForm(() -> {
                this.interceptFinish();
                this.setCloseTypeInternal(IWizard.CloseType.Finished);
            });
        }
    }

    @Override
    public void doCancel() {
        if (this.isOpen()) {
            this.runWithinContainerForm(() -> {
                this.interceptCancel();
                this.setCloseTypeInternal(IWizard.CloseType.Cancelled);
            });
        }
    }

    @Override
    public void doSuspend() {
        if (this.isOpen()) {
            this.runWithinContainerForm(() -> {
                this.interceptSuspend();
                this.setCloseTypeInternal(IWizard.CloseType.Suspended);
            });
        }
    }

    @Override
    public void doReset() {
        this.runWithinContainerForm(this::interceptReset);
    }

    @Override
    public void doAppLinkAction(String ref) {
        if (this.isOpen()) {
            this.runWithinContainerForm(() -> this.interceptAppLinkAction(ref));
        }
    }

    @Override
    public void doStepAction(IWizardStep<? extends IForm> step) {
        if (this.isOpen()) {
            this.runWithinContainerForm(() -> this.interceptStepAction(step));
        }
    }

    private void assertClosed() {
        if (!this.isClosed()) {
            throw new ProcessingException("wizard is already started", new Object[0]);
        }
    }

    @Override
    public IForm getWizardForm() {
        return (IForm)this.propertySupport.getProperty("wizardForm");
    }

    @Override
    public void setWizardForm(IForm form) {
        this.propertySupport.setProperty("wizardForm", (Object)form);
    }

    @Override
    public IWizardContainerForm createContainerForm() {
        return this.interceptCreateContainerForm();
    }

    @Override
    public IWizardContainerForm getContainerForm() {
        return this.m_containerForm;
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    protected final void interceptActiveStepChanged() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardActiveStepChangedChain chain = new WizardChains.WizardActiveStepChangedChain(extensions);
        chain.execActiveStepChanged();
    }

    protected final void interceptSuspend() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardSuspendChain chain = new WizardChains.WizardSuspendChain(extensions);
        chain.execSuspend();
    }

    protected final void interceptRefreshButtonPolicy() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardRefreshButtonPolicyChain chain = new WizardChains.WizardRefreshButtonPolicyChain(extensions);
        chain.execRefreshButtonPolicy();
    }

    protected final void interceptCancel() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardCancelChain chain = new WizardChains.WizardCancelChain(extensions);
        chain.execCancel();
    }

    protected final void interceptStart() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardStartChain chain = new WizardChains.WizardStartChain(extensions);
        chain.execStart();
    }

    protected final void interceptPostStart() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardPostStartChain chain = new WizardChains.WizardPostStartChain(extensions);
        chain.execPostStart();
    }

    protected final IWizardContainerForm interceptCreateContainerForm() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardCreateContainerFormChain chain = new WizardChains.WizardCreateContainerFormChain(extensions);
        return chain.execCreateContainerForm();
    }

    protected void interceptDecorateContainerForm() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardDecorateContainerFormChain chain = new WizardChains.WizardDecorateContainerFormChain(extensions);
        chain.execDecorateContainerForm();
    }

    protected final void interceptAnyFieldChanged(IFormField source) {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardAnyFieldChangedChain chain = new WizardChains.WizardAnyFieldChangedChain(extensions);
        chain.execAnyFieldChanged(source);
    }

    protected final void interceptContainerFormClosed() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardContainerFormClosedChain chain = new WizardChains.WizardContainerFormClosedChain(extensions);
        chain.execContainerFormClosed();
    }

    protected final void interceptReset() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardResetChain chain = new WizardChains.WizardResetChain(extensions);
        chain.execReset();
    }

    protected final void interceptAppLinkAction(String ref) {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardAppLinkActionChain chain = new WizardChains.WizardAppLinkActionChain(extensions);
        chain.execAppLinkAction(ref);
    }

    protected final void interceptStepAction(IWizardStep<? extends IForm> wizardStep) {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardStepActionChain chain = new WizardChains.WizardStepActionChain(extensions);
        chain.execStepAction(wizardStep);
    }

    protected final void interceptPreviousStep() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardPreviousStepChain chain = new WizardChains.WizardPreviousStepChain(extensions);
        chain.execPreviousStep();
    }

    protected final void interceptNextStep() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardNextStepChain chain = new WizardChains.WizardNextStepChain(extensions);
        chain.execNextStep();
    }

    protected final void interceptFinish() {
        List<? extends IWizardExtension<? extends AbstractWizard>> extensions = this.getAllExtensions();
        WizardChains.WizardFinishChain chain = new WizardChains.WizardFinishChain(extensions);
        chain.execFinish();
    }

    protected void runWithinContainerForm(IRunnable runnable) {
        ClientRunContexts.copyCurrent().withForm(this.getContainerForm()).run(runnable);
    }

    protected static class LocalWizardExtension<OWNER extends AbstractWizard>
    extends AbstractExtension<OWNER>
    implements IWizardExtension<OWNER> {
        public LocalWizardExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execActiveStepChanged(WizardChains.WizardActiveStepChangedChain chain) {
            ((AbstractWizard)this.getOwner()).execActiveStepChanged();
        }

        @Override
        public void execSuspend(WizardChains.WizardSuspendChain chain) {
            ((AbstractWizard)this.getOwner()).execSuspend();
        }

        @Override
        public void execRefreshButtonPolicy(WizardChains.WizardRefreshButtonPolicyChain chain) {
            ((AbstractWizard)this.getOwner()).execRefreshButtonPolicy();
        }

        @Override
        public void execCancel(WizardChains.WizardCancelChain chain) {
            ((AbstractWizard)this.getOwner()).execCancel();
        }

        @Override
        public void execStart(WizardChains.WizardStartChain chain) {
            ((AbstractWizard)this.getOwner()).execStart();
        }

        @Override
        public void execPostStart(WizardChains.WizardPostStartChain chain) {
            ((AbstractWizard)this.getOwner()).execPostStart();
        }

        @Override
        public IWizardContainerForm execCreateContainerForm(WizardChains.WizardCreateContainerFormChain chain) {
            return ((AbstractWizard)this.getOwner()).execCreateContainerForm();
        }

        @Override
        public void execDecorateContainerForm(WizardChains.WizardDecorateContainerFormChain chain) {
            ((AbstractWizard)this.getOwner()).execDecorateContainerForm();
        }

        @Override
        public void execAnyFieldChanged(WizardChains.WizardAnyFieldChangedChain chain, IFormField source) {
            ((AbstractWizard)this.getOwner()).execAnyFieldChanged(source);
        }

        @Override
        public void execContainerFormClosed(WizardChains.WizardContainerFormClosedChain chain) {
            ((AbstractWizard)this.getOwner()).execContainerFormClosed();
        }

        @Override
        public void execReset(WizardChains.WizardResetChain chain) {
            ((AbstractWizard)this.getOwner()).execReset();
        }

        @Override
        public void execAppLinkAction(WizardChains.WizardAppLinkActionChain chain, String ref) {
            ((AbstractWizard)this.getOwner()).execAppLinkAction(ref);
        }

        @Override
        public void execStepAction(WizardChains.WizardStepActionChain chain, IWizardStep<? extends IForm> step) {
            ((AbstractWizard)this.getOwner()).execStepAction(step);
        }

        @Override
        public void execPreviousStep(WizardChains.WizardPreviousStepChain chain) {
            ((AbstractWizard)this.getOwner()).execPreviousStep();
        }

        @Override
        public void execNextStep(WizardChains.WizardNextStepChain chain) {
            ((AbstractWizard)this.getOwner()).execNextStep();
        }

        @Override
        public void execFinish(WizardChains.WizardFinishChain chain) {
            ((AbstractWizard)this.getOwner()).execFinish();
        }
    }
}

