/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile.fields;

import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.tile.AbstractWidgetTile;
import org.eclipse.scout.rt.client.ui.tile.IFormFieldTile;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="824f17e6-a83f-4e5b-8915-34737a786265")
public abstract class AbstractFormFieldTile<T extends IFormField>
extends AbstractWidgetTile<T>
implements IFormFieldTile<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFormFieldTile.class);

    public AbstractFormFieldTile() {
        this(true);
    }

    public AbstractFormFieldTile(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void handleInitException(Exception exception) {
        LOG.error("Error while initializing tile {}: {}", new Object[]{this.getTileWidget(), exception.getMessage(), exception});
        ((IFormField)this.getTileWidget()).addErrorStatus(TEXTS.get((String)"ErrorWhileLoadingData"));
    }

    @Override
    protected void handleLoadDataException(Throwable e) {
        super.handleLoadDataException(e);
        if (e instanceof VetoException) {
            ((IFormField)this.getTileWidget()).addErrorStatus((IStatus)((ProcessingException)e).getStatus());
        } else if (!(e instanceof FutureCancelledError) && !(e instanceof ThreadInterruptedError)) {
            ((IFormField)this.getTileWidget()).addErrorStatus(TEXTS.get((String)"ErrorWhileLoadingData"));
        }
    }

    @Override
    public void setTileWidget(T widget) {
        super.setTileWidget(widget);
        if (widget != null) {
            this.initTileWidgetConfig();
        }
    }

    protected void initTileWidgetConfig() {
        IFormField widget = (IFormField)this.getTileWidget();
        if (this.getConfiguredLabel() != null) {
            widget.setLabel(this.getConfiguredLabel());
        }
        if (this.getConfiguredLabelVisible() != null) {
            widget.setLabelVisible(this.getConfiguredLabelVisible());
        }
        if ("dashboard".equals(this.getDisplayStyle())) {
            widget.setLabelPosition((byte)4);
            widget.setMandatory(false);
            widget.setStatusVisible(false);
        }
    }

    @Override
    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected String getConfiguredDisplayStyle() {
        return "dashboard";
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    protected String getConfiguredLabel() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    protected Boolean getConfiguredLabelVisible() {
        return null;
    }

    @Override
    protected void beforeLoadData() {
        ((IFormField)this.getTileWidget()).clearErrorStatus();
    }

    @Override
    public void onLoadDataCancel() {
        this.setLoading(false);
        ((IFormField)this.getTileWidget()).addErrorStatus(TEXTS.get((String)"ErrorWhileLoadingData"));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [m_widget=" + String.valueOf(this.getTileWidget()) + ", m_container=" + String.valueOf(this.getParent()) + "]";
    }
}

