/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import org.eclipse.scout.rt.client.ui.form.fields.LogicalGridLayoutConfig;

public class TileGridLayoutConfig
extends LogicalGridLayoutConfig {
    private int m_maxWidth = -1;

    public TileGridLayoutConfig() {
        this.setColumnWidth(210);
        this.setRowHeight(155);
        this.setHGap(15);
        this.setVGap(15);
    }

    public TileGridLayoutConfig(TileGridLayoutConfig config) {
        super(config);
        this.setMaxWidth(config.getMaxWidth());
    }

    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.m_maxWidth = maxWidth;
    }

    public TileGridLayoutConfig withMaxWidth(int maxWidth) {
        this.setMaxWidth(maxWidth);
        return this;
    }

    public TileGridLayoutConfig usePreferredWidth(int gridColumnCount) {
        this.setMaxWidth(this.calculatePreferredWidth(gridColumnCount));
        return this;
    }

    @Override
    public TileGridLayoutConfig withColumnWidth(int columnWidth) {
        this.setColumnWidth(columnWidth);
        return this;
    }

    @Override
    public TileGridLayoutConfig withRowHeight(int rowHeight) {
        this.setRowHeight(rowHeight);
        return this;
    }

    @Override
    public TileGridLayoutConfig withHGap(int hgap) {
        this.setHGap(hgap);
        return this;
    }

    @Override
    public TileGridLayoutConfig withVGap(int vgap) {
        this.setVGap(vgap);
        return this;
    }

    @Override
    public TileGridLayoutConfig withMinWidth(int minWidth) {
        this.setMinWidth(minWidth);
        return this;
    }

    public int calculatePreferredWidth(int gridColumnCount) {
        return gridColumnCount * this.getColumnWidth() + (gridColumnCount - 1) * this.getHGap();
    }

    @Override
    public TileGridLayoutConfig copy() {
        return new TileGridLayoutConfig(this);
    }
}

