/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.util.Comparator;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenuOwner;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITileGridContextMenu;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileFilter;
import org.eclipse.scout.rt.client.ui.tile.ITileGridUIFacade;
import org.eclipse.scout.rt.client.ui.tile.TileGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.tile.TileGridListener;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;

public interface ITileGrid<T extends ITile>
extends IWidget,
IExtensibleObject,
IContributionOwner,
IContextMenuOwner {
    public static final String PROP_TILES = "tiles";
    public static final String PROP_SELECTED_TILES = "selectedTiles";
    public static final String PROP_FILTERED_TILES = "filteredTiles";
    public static final String PROP_GRID_COLUMN_COUNT = "gridColumnCount";
    public static final String PROP_WITH_PLACEHOLDERS = "withPlaceholders";
    public static final String PROP_SCROLLABLE = "scrollable";
    public static final String PROP_SELECTABLE = "selectable";
    public static final String PROP_MULTI_SELECT = "multiSelect";
    public static final String PROP_LOGICAL_GRID = "logicalGrid";
    public static final String PROP_LAYOUT_CONFIG = "layoutConfig";
    public static final String PROP_CONTEXT_MENU = "contextMenus";
    public static final String PROP_VIRTUAL = "virtual";
    public static final String PROP_ANIMATE_TILE_REMOVAL = "animateTileRemoval";
    public static final String PROP_ANIMATE_TILE_INSERTION = "animateTileInsertion";
    public static final String PROP_TEXT_FILTER_ENABLED = "textFilterEnabled";
    public static final String PROP_WRAPPABLE = "wrappable";
    public static final String ASYNC_LOAD_JOBNAME_PREFIX = "tileAsyncDataLoadJob";
    public static final String ASYNC_LOAD_IDENTIFIER_PREFIX = "tileAsyncDataLoadIdentifier";
    public static final String WINDOW_IDENTIFIER_PREFIX = "tileDataLoadWindowsIdentifier";
    public static final String RUN_CONTEXT_TILE_LOAD_CANCELLABLE = "tileDataLoadCancellable";
    @Deprecated
    public static final String PROP_ASYNC_LOAD_JOBNAME_PREFIX = "tileAsyncDataLoadJob";
    @Deprecated
    public static final String PROP_ASYNC_LOAD_IDENTIFIER_PREFIX = "tileAsyncDataLoadIdentifier";
    @Deprecated
    public static final String PROP_WINDOW_IDENTIFIER_PREFIX = "tileDataLoadWindowsIdentifier";
    public static final String LOGICAL_GRID_HORIZONTAL = "HorizontalGrid";
    public static final String LOGICAL_GRID_VERTICAL_SMART = "VerticalSmartGrid";

    public List<T> getTiles();

    public int getTileCount();

    public void setTiles(List<T> var1);

    public int getGridColumnCount();

    public void setGridColumnCount(int var1);

    public boolean isWithPlaceholders();

    public void setWithPlaceholders(boolean var1);

    public boolean isSelectable();

    public void setSelectable(boolean var1);

    public boolean isMultiSelect();

    public void setMultiSelect(boolean var1);

    public boolean isScrollable();

    public void setScrollable(boolean var1);

    public boolean isWrappable();

    public void setWrappable(boolean var1);

    public String getLogicalGrid();

    public void setLogicalGrid(String var1);

    public void setLayoutConfig(TileGridLayoutConfig var1);

    public TileGridLayoutConfig getLayoutConfig();

    public boolean isVirtual();

    public void setVirtual(boolean var1);

    public boolean isAnimateTileRemoval();

    public void setAnimateTileRemoval(boolean var1);

    public boolean isAnimateTileInsertion();

    public void setAnimateTileInsertion(boolean var1);

    public boolean isTextFilterEnabled();

    public void setTextFilterEnabled(boolean var1);

    public void addTiles(List<T> var1);

    public void addTile(T var1);

    public void deleteTiles(List<T> var1);

    public void deleteTile(T var1);

    public void deleteAllTiles();

    public void selectTiles(List<T> var1);

    public void selectTile(T var1);

    public void selectAllTiles();

    public void deselectTiles(List<T> var1);

    public void deselectTile(T var1);

    public void deselectAllTiles();

    public List<T> getSelectedTiles();

    public int getSelectedTileCount();

    public T getSelectedTile();

    public T getTileByClass(Class<T> var1);

    public JobInput createAsyncLoadJobInput(ITile var1);

    public void loadTileData();

    public void ensureTileDataLoaded();

    public List<ITileFilter<T>> getFilters();

    public void addFilter(ITileFilter<T> var1);

    public void addFilter(ITileFilter<T> var1, boolean var2);

    public void removeFilter(ITileFilter<T> var1);

    public void removeFilter(ITileFilter<T> var1, boolean var2);

    public void filter();

    public List<T> getFilteredTiles();

    public int getFilteredTileCount();

    public void setComparator(Comparator<T> var1);

    public void setComparator(Comparator<T> var1, boolean var2);

    public Comparator<T> getComparator();

    public void sort();

    public void setMenus(List<? extends IMenu> var1);

    @Override
    public ITileGridContextMenu getContextMenu();

    public IFastListenerList<TileGridListener> tileGridListeners();

    default public void addTileGridListener(TileGridListener listener) {
        this.tileGridListeners().add((Object)listener);
    }

    default public void removeTileGridListener(TileGridListener listener) {
        this.tileGridListeners().remove((Object)listener);
    }

    public ITileGridUIFacade getUIFacade();
}

