/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.tile.AbstractTile;
import org.eclipse.scout.rt.client.ui.tile.IWidgetTile;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="b9299ac7-2401-4ff5-9806-3dafbfce5d22")
public abstract class AbstractWidgetTile<T extends IWidget>
extends AbstractTile
implements IWidgetTile<T> {
    public AbstractWidgetTile() {
        this(true);
    }

    public AbstractWidgetTile(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setTileWidget(this.createTileWidgetInternal());
        if (this.getTileWidget() == null) {
            throw new IllegalStateException("TileWidget must not be null]");
        }
    }

    protected Class<T> getConfiguredTileWidget() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class result = ConfigurationUtility.filterClass((Class[])dca, IWidget.class);
        return result;
    }

    protected T createTileWidgetInternal() {
        IWidget field = null;
        Class<T> fieldClass = this.getConfiguredTileWidget();
        if (fieldClass != null) {
            field = (IWidget)ConfigurationUtility.newInnerInstance((Object)this, fieldClass);
        }
        return (T)field;
    }

    @Override
    public T getTileWidget() {
        return (T)((IWidget)this.propertySupport.getProperty("tileWidget"));
    }

    public void setTileWidget(T widget) {
        if (this.getTileWidget() != null) {
            this.getTileWidget().dispose();
        }
        if (widget != null) {
            widget.setParentInternal(this);
            widget.init();
        }
        this.propertySupport.setProperty("tileWidget", widget);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getTileWidget())});
    }
}

