/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.tile.ITileExtension;
import org.eclipse.scout.rt.client.extension.ui.tile.TileChains;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.datachange.ActiveFormDataChangeManager;
import org.eclipse.scout.rt.client.ui.desktop.datachange.DataChangeEvent;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.eclipse.scout.rt.client.ui.tile.TileDataLoadManager;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.data.colorscheme.ColorScheme;
import org.eclipse.scout.rt.shared.data.colorscheme.IColorScheme;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="126ee77e-7e43-4b7b-94b4-a00f255e2492")
public abstract class AbstractTile
extends AbstractWidget
implements ITile {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTile.class);
    private final ObjectExtensions<AbstractTile, ITileExtension<? extends AbstractTile>> m_objectExtensions = new ObjectExtensions((Object)this, false);
    private IDataChangeListener m_internalDataChangeListener;
    private boolean m_filterAccepted = true;
    private volatile boolean m_loaded = false;
    private IFuture<Void> m_loadJobFuture;

    public AbstractTile() {
        this(true);
    }

    public AbstractTile(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setOrder(this.calculateViewOrder());
        this.setColorScheme(this.getConfiguredColorScheme());
        this.setCssClass(this.getConfiguredCssClass());
        this.setDisplayStyle(this.getConfiguredDisplayStyle());
        this.setGridDataHints(this.getConfiguredGridDataHints());
    }

    @Override
    protected final void initInternal() {
        super.initInternal();
        try {
            this.initTileInternal();
            this.interceptInitTile();
        }
        catch (Exception e) {
            this.handleInitException(e);
        }
    }

    protected void initTileInternal() {
        if (this.getConfiguredAutoLoadDataOnInit()) {
            this.loadData();
        }
    }

    protected void handleInitException(Exception exception) {
        throw new PlatformException("Exception occurred while initializing tile", new Object[]{exception});
    }

    protected void execInitTile() {
    }

    @Override
    protected final void disposeInternal() {
        this.disposeTileInternal();
        this.cancelLoading();
        this.interceptDisposeTile();
        super.disposeInternal();
    }

    protected void disposeTileInternal() {
        this.unregisterDataChangeListener(new Object[0]);
    }

    protected void execDisposeTile() {
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && ITile.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=80.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected IColorScheme getConfiguredColorScheme() {
        return ColorScheme.DEFAULT;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected String getConfiguredDisplayStyle() {
        return "default";
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=15.0)
    protected GridData getConfiguredGridDataHints() {
        return new GridData(-1, -1, this.getConfiguredGridW(), this.getConfiguredGridH(), this.getConfiguredGridWeightX(), this.getConfiguredGridWeightY(), false, false, -1, -1, true, true, 0, 0);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=20.0)
    protected int getConfiguredGridW() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=30.0)
    protected int getConfiguredGridH() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=60.0)
    protected int getConfiguredGridWeightX() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=70.0)
    protected int getConfiguredGridWeightY() {
        return 0;
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("order");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("order", order);
    }

    @Override
    public GridData getGridDataHints() {
        return new GridData((GridData)this.propertySupport.getProperty("gridDataHints"));
    }

    @Override
    public void setGridDataHints(GridData hints) {
        this.propertySupport.setProperty("gridDataHints", (Object)new GridData(hints));
    }

    @Override
    public IColorScheme getColorScheme() {
        return (IColorScheme)this.propertySupport.getProperty("colorScheme");
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        this.propertySupport.setProperty("colorScheme", (Object)colorScheme);
    }

    @Override
    public String getDisplayStyle() {
        return this.propertySupport.getPropertyString("displayStyle");
    }

    protected void setDisplayStyle(String style) {
        this.propertySupport.setPropertyString("displayStyle", style);
    }

    protected IDataChangeListener getInternalDataChangeListener() {
        return this.m_internalDataChangeListener;
    }

    protected void setInternalDataChangeListener(IDataChangeListener internalDataChangeListener) {
        this.m_internalDataChangeListener = internalDataChangeListener;
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    public void setLoaded(boolean loaded) {
        this.m_loaded = loaded;
    }

    protected IFuture<Void> getLoadJobFuture() {
        return this.m_loadJobFuture;
    }

    @Override
    public void registerDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = event -> {
                if (this.isLoaded()) {
                    this.interceptDataChanged(event);
                }
            };
            IForm rootForm = FormUtility.findRootForm(this.getParentOfType(IForm.class));
            IDesktop desktop = IDesktop.CURRENT.get();
            boolean isView = desktop.getViews().contains(rootForm);
            if (isView) {
                ((ActiveFormDataChangeManager)BEANS.get(ActiveFormDataChangeManager.class)).add(rootForm, this.m_internalDataChangeListener, true, dataTypes);
            } else {
                desktop.dataChangeDesktopInForegroundListeners().add(this.m_internalDataChangeListener, true, dataTypes);
            }
        }
    }

    @Override
    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            ClientSessionProvider.currentSession().getDesktop().removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
            ((ActiveFormDataChangeManager)BEANS.get(ActiveFormDataChangeManager.class)).remove(this.m_internalDataChangeListener);
        }
    }

    protected void execDataChanged(DataChangeEvent event) {
        this.loadData();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredAutoLoadDataOnInit() {
        return true;
    }

    @Override
    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)true);
        IWidget parent = this.getParent();
        if (parent == null) {
            return simpleClassId;
        }
        return parent.classId() + "_" + simpleClassId;
    }

    @Override
    public void setFilterAccepted(boolean filterAccepted) {
        this.m_filterAccepted = filterAccepted;
    }

    @Override
    public boolean isFilterAccepted() {
        return this.m_filterAccepted;
    }

    @Override
    public void ensureDataLoaded() {
        if (!this.isLoaded()) {
            this.loadData();
        }
    }

    @Override
    public void loadData() {
        if (this.isLoading()) {
            return;
        }
        this.beforeLoadData();
        try {
            this.interceptLoadData();
        }
        catch (Exception e) {
            this.handleLoadDataException(e);
        }
    }

    @Override
    public void cancelLoading() {
        if (this.getLoadJobFuture() != null) {
            this.getLoadJobFuture().addExecutionHint("manualCancellationMarker");
            this.getLoadJobFuture().cancel(true);
        }
    }

    @Override
    public void reloadData() {
        if (!this.isLoading()) {
            this.loadData();
            return;
        }
        this.cancelLoading();
        this.addPropertyChangeListener("loading", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!AbstractTile.this.isLoading()) {
                    AbstractTile.this.removePropertyChangeListener(this);
                    AbstractTile.this.reloadData();
                }
            }
        });
    }

    protected void beforeLoadData() {
    }

    protected void execLoadData() {
        ITileDataLoader dataLoader = this.createDataLoader();
        if (dataLoader != null) {
            dataLoader.loadData();
        }
    }

    protected ITileDataLoader createDataLoader() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [m_container=" + String.valueOf(this.getParent()) + "]";
    }

    protected void handleLoadDataException(Throwable e) {
        if (e instanceof VetoException) {
            LOG.info("VetoException on {}: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
        } else if (e instanceof FutureCancelledError) {
            LOG.debug("FutureCancelledError on {}: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
        } else if (e instanceof ThreadInterruptedError) {
            LOG.debug("ThreadInterruptedError on {}: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
        } else {
            LOG.error("Unexpected error on {}", (Object)this.getClass().getName(), (Object)e);
        }
    }

    @Override
    public void onLoadDataCancel() {
        this.setLoading(false);
    }

    public final List<? extends ITileExtension<? extends AbstractTile>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected final void interceptDisposeTile() {
        List<? extends ITileExtension<? extends AbstractTile>> extensions = this.getAllExtensions();
        TileChains.TileDisposeTileChain chain = new TileChains.TileDisposeTileChain(extensions);
        chain.execDisposeTile();
    }

    protected final void interceptInitTile() {
        List<? extends ITileExtension<? extends AbstractTile>> extensions = this.getAllExtensions();
        TileChains.TileInitTileChain chain = new TileChains.TileInitTileChain(extensions);
        chain.execInitTile();
    }

    protected final void interceptLoadData() {
        List<? extends ITileExtension<? extends AbstractTile>> extensions = this.getAllExtensions();
        TileChains.TileLoadDataTileChain chain = new TileChains.TileLoadDataTileChain(extensions);
        chain.execLoadData();
    }

    protected final void interceptDataChanged(DataChangeEvent event) {
        List<? extends ITileExtension<? extends AbstractTile>> extensions = this.getAllExtensions();
        TileChains.TileDataChangedTileChain chain = new TileChains.TileDataChangedTileChain(extensions);
        chain.execDataChanged(event);
    }

    protected ITileExtension<? extends AbstractTile> createLocalExtension() {
        return new LocalTileExtension<AbstractTile>(this);
    }

    public abstract class AbstractTileDataLoader<DATA>
    implements ITileDataLoader {
        protected abstract DATA loadDataAsync();

        protected abstract void setTileData(DATA var1);

        @Override
        public void loadData() {
            if (AbstractTile.this.isLoading()) {
                return;
            }
            AbstractTile.this.setLoading(true);
            try {
                ITileGrid tileGridParent = AbstractTile.this.getParentOfType(ITileGrid.class);
                IForm formParent = AbstractTile.this.getParentOfType(IForm.class);
                AbstractTile.this.m_loadJobFuture = ((TileDataLoadManager)BEANS.get(TileDataLoadManager.class)).schedule(() -> {
                    try {
                        DATA data = this.doLoadData();
                        ((TileDataLoadManager)BEANS.get(TileDataLoadManager.class)).runInModelJob(() -> {
                            AbstractTile.this.m_loadJobFuture = null;
                            AbstractTile.this.setLoading(false);
                            this.updateModelData(data);
                        });
                    }
                    catch (Throwable e) {
                        ((TileDataLoadManager)BEANS.get(TileDataLoadManager.class)).runInModelJob(() -> {
                            AbstractTile.this.m_loadJobFuture = null;
                            AbstractTile.this.setLoading(false);
                            AbstractTile.this.handleLoadDataException(e);
                        });
                    }
                }, tileGridParent != null ? tileGridParent.createAsyncLoadJobInput(AbstractTile.this) : ModelJobs.newInput(ClientRunContexts.copyCurrent().withForm(formParent != null ? formParent : IForm.CURRENT.get())));
            }
            catch (RuntimeException e) {
                AbstractTile.this.setLoading(false);
                AbstractTile.this.handleLoadDataException(e);
            }
        }

        protected DATA doLoadData() {
            try {
                DATA data = this.loadDataAsync();
                AbstractTile.this.setLoaded(true);
                return data;
            }
            catch (Exception e) {
                AbstractTile.this.setLoaded(!((RunMonitor)RunMonitor.CURRENT.get()).isCancelled());
                throw e;
            }
        }

        protected void updateModelData(DATA data) {
            try {
                this.setTileData(data);
            }
            catch (Exception e) {
                AbstractTile.this.handleLoadDataException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface ITileDataLoader {
        public void loadData();
    }

    protected static class LocalTileExtension<OWNER extends AbstractTile>
    extends AbstractExtension<OWNER>
    implements ITileExtension<OWNER> {
        public LocalTileExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDisposeTile(TileChains.TileDisposeTileChain chain) {
            ((AbstractTile)this.getOwner()).execDisposeTile();
        }

        @Override
        public void execInitTile(TileChains.TileInitTileChain chain) {
            ((AbstractTile)this.getOwner()).execInitTile();
        }

        @Override
        public void execLoadData(TileChains.TileLoadDataTileChain chain) {
            ((AbstractTile)this.getOwner()).execLoadData();
        }

        @Override
        public void execDataChanged(TileChains.TileDataChangedTileChain chain, DataChangeEvent event) {
            ((AbstractTile)this.getOwner()).execDataChanged(event);
        }
    }
}

