/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.tile;

import java.util.Collection;
import java.util.Set;
import org.eclipse.scout.rt.client.res.AttachmentSupport;
import org.eclipse.scout.rt.client.ui.tile.AbstractTile;
import org.eclipse.scout.rt.client.ui.tile.IHtmlTile;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.BinaryResource;

@ClassId(value="22f26922-32e7-49f1-9180-b48fbb5e75cd")
public abstract class AbstractHtmlTile
extends AbstractTile
implements IHtmlTile {
    protected final AttachmentSupport m_attachmentSupport = (AttachmentSupport)BEANS.get(AttachmentSupport.class);

    public AbstractHtmlTile() {
        this(true);
    }

    public AbstractHtmlTile(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setContent(this.getConfiguredContent());
        this.setHtmlEnabled(this.getConfiguredHtmlEnabled());
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredContent() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=11.0)
    protected boolean getConfiguredHtmlEnabled() {
        return true;
    }

    @Override
    public String getContent() {
        return this.propertySupport.getPropertyString("content");
    }

    @Override
    public void setContent(String content) {
        this.propertySupport.setProperty("content", (Object)content);
    }

    @Override
    public void setAttachments(Collection<? extends BinaryResource> attachments) {
        this.m_attachmentSupport.setAttachments(attachments);
    }

    @Override
    public void addAttachment(BinaryResource resource) {
        this.m_attachmentSupport.addAttachment(resource);
    }

    @Override
    public void removeAttachment(BinaryResource resource) {
        this.m_attachmentSupport.removeAttachment(resource);
    }

    @Override
    public Set<BinaryResource> getAttachments() {
        return this.m_attachmentSupport.getAttachments();
    }

    @Override
    public BinaryResource getAttachment(String filename) {
        return this.m_attachmentSupport.getAttachment(filename);
    }

    @Override
    public void setHtmlEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("htmlEnabled", enabled);
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.propertySupport.getPropertyBool("htmlEnabled");
    }
}

