/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.popup;

import java.util.Set;
import org.eclipse.scout.rt.client.ui.popup.IPopup;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@Bean
public class PopupManager
extends AbstractPropertyObserver {
    public static final String PROP_POPUPS = "popups";

    public PopupManager() {
        this.propertySupport.setPropertySet(PROP_POPUPS, (Set)CollectionUtility.emptyHashSet());
    }

    public Set<IPopup> getPopups() {
        return CollectionUtility.hashSet(this.getPopupsInternal());
    }

    protected Set<IPopup> getPopupsInternal() {
        return this.propertySupport.getPropertySet(PROP_POPUPS);
    }

    public <T extends IPopup> T getPopupByClass(Class<T> popupClass) {
        return (T)((IPopup)this.getPopupsInternal().stream().filter(popupClass::isInstance).findFirst().orElse(null));
    }

    protected void setPopupsInternal(Set<? extends IPopup> popups) {
        this.propertySupport.setPropertySet(PROP_POPUPS, popups);
    }

    public void open(IPopup popup) {
        Set<IPopup> popups = this.getPopups();
        popups.add(popup);
        this.setPopupsInternal(popups);
    }

    public void close(IPopup popup) {
        Set<IPopup> popups = this.getPopups();
        popups.remove(popup);
        this.setPopupsInternal(popups);
    }
}

