/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.popup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.popup.AbstractPopup;
import org.eclipse.scout.rt.client.ui.popup.IWidgetPopup;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="4ec758a3-178f-4de9-bc56-a4f28f801df1")
public abstract class AbstractWidgetPopup<T extends IWidget>
extends AbstractPopup
implements IWidgetPopup<T> {
    private T m_content;

    public AbstractWidgetPopup() {
        this(true);
    }

    public AbstractWidgetPopup(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setClosable(this.getConfiguredClosable());
        this.setMovable(this.getConfiguredMovable());
        this.setResizable(this.getConfiguredResizable());
        this.setContent(this.createContent());
        if (this.getContent() instanceof ICompositeField) {
            FormUtility.rebuildFieldGrid((ICompositeField)this.getContent());
        }
    }

    protected boolean getConfiguredClosable() {
        return false;
    }

    @Override
    public void setClosable(boolean closable) {
        this.propertySupport.setPropertyBool("closable", closable);
    }

    @Override
    public boolean isClosable() {
        return this.propertySupport.getPropertyBool("closable");
    }

    protected boolean getConfiguredMovable() {
        return false;
    }

    @Override
    public void setMovable(boolean movable) {
        this.propertySupport.setPropertyBool("movable", movable);
    }

    @Override
    public boolean isMovable() {
        return this.propertySupport.getPropertyBool("movable");
    }

    protected boolean getConfiguredResizable() {
        return false;
    }

    @Override
    public void setResizable(boolean enabled) {
        this.propertySupport.setPropertyBool("resizable", enabled);
    }

    @Override
    public boolean isResizable() {
        return this.propertySupport.getPropertyBool("resizable");
    }

    protected Class<T> getConfiguredContent() {
        return null;
    }

    protected T createContent() {
        Class<T> configuredContent = this.getConfiguredContent();
        if (configuredContent != null) {
            return (T)((IWidget)ConfigurationUtility.newInnerInstance((Object)this, configuredContent));
        }
        return null;
    }

    @Override
    public T getContent() {
        return this.m_content;
    }

    public void setContent(T content) {
        if (this.m_content != null) {
            this.m_content.setParentInternal(null);
        }
        this.m_content = content;
        if (this.m_content != null) {
            this.m_content.setParentInternal(this);
        }
    }

    @Override
    protected boolean getConfiguredAnimateOpening() {
        return true;
    }

    @Override
    protected boolean getConfiguredAnimateResize() {
        return true;
    }

    @Override
    public void open() {
        this.init();
        super.open();
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getContent())});
    }
}

