/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.popup;

import java.util.List;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.popup.AbstractWidgetPopup;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;

@ClassId(value="5930294f-05ea-4fd3-be84-963aac6ee4f8")
public abstract class AbstractFormPopup<T extends IForm>
extends AbstractWidgetPopup<T> {
    public AbstractFormPopup() {
        this(true);
    }

    public AbstractFormPopup(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected T createContent() {
        return this.createForm();
    }

    @Override
    public void setContent(T content) {
        super.setContent(content);
        if (content != null) {
            this.decorateForm((IForm)content);
        }
    }

    protected T createForm() {
        Class configuredContent = this.getConfiguredContent();
        if (configuredContent != null) {
            return (T)((IForm)ConfigurationUtility.newInnerInstance((Object)this, configuredContent));
        }
        return null;
    }

    @Override
    public void open() {
        this.ensureFormStarted();
        super.open();
    }

    public void ensureFormStarted() {
        if (this.getContent() == null || !((IForm)this.getContent()).isFormStartable()) {
            return;
        }
        this.startForm();
        FormListener listener = e -> {
            if (e.getType() == 3010) {
                this.close();
            }
        };
        ((IForm)this.getContent()).addFormListener(listener, new Integer[0]);
    }

    protected void startForm() {
        ((IForm)this.getContent()).start();
    }

    protected void decorateForm(IForm form) {
        form.setShowOnStart(false);
        form.setDisplayHint(20);
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        widgetsToDispose.remove(this.getContent());
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        widgets.remove(this.getContent());
        super.initChildren(widgets);
    }

    @Override
    protected void disposeInternal() {
        IForm form = (IForm)this.getContent();
        if (form != null && !form.isFormClosed()) {
            form.doClose();
        }
        super.disposeInternal();
    }
}

