/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.notification;

import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.notification.INotification;
import org.eclipse.scout.rt.client.ui.notification.INotificationUIFacade;
import org.eclipse.scout.rt.client.ui.notification.NotificationEvent;
import org.eclipse.scout.rt.client.ui.notification.NotificationListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;

@ClassId(value="759627bb-02e5-4db2-812c-aac00b80cdb6")
public class Notification
extends AbstractWidget
implements INotification {
    private IStatus m_status;
    private boolean m_closable;
    private boolean m_htmlEnabled;
    private Consumer<String> m_appLinkConsumer;
    private final FastListenerList<NotificationListener> m_listenerList = new FastListenerList();
    private final INotificationUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());

    public Notification(String text) {
        this((IStatus)new Status(text, 256));
    }

    public Notification(IStatus status) {
        this(status, false);
    }

    public Notification(IStatus status, boolean closable) {
        this(status, closable, false);
    }

    public Notification(IStatus status, boolean closable, boolean htmlEnabled) {
        this(status, closable, htmlEnabled, null);
    }

    public Notification(IStatus status, boolean closable, boolean htmlEnabled, Consumer<String> appLinkConsumer) {
        this.m_status = status;
        this.m_closable = closable;
        this.m_htmlEnabled = htmlEnabled;
        this.m_appLinkConsumer = appLinkConsumer;
    }

    @Override
    public Notification withStatus(IStatus status) {
        this.m_status = status;
        return this;
    }

    @Override
    public IStatus getStatus() {
        return this.m_status;
    }

    @Override
    public Notification withClosable(boolean closable) {
        this.m_closable = closable;
        return this;
    }

    @Override
    public boolean isClosable() {
        return this.m_closable;
    }

    @Override
    public Notification withHtmlEnabled(boolean htmlEnabled) {
        this.m_htmlEnabled = htmlEnabled;
        return this;
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.m_htmlEnabled;
    }

    public Notification withAppLinkConsumer(Consumer<String> appLinkConsumer) {
        this.m_appLinkConsumer = appLinkConsumer;
        return this;
    }

    protected Consumer<String> getAppLinkConsumer() {
        return this.m_appLinkConsumer;
    }

    protected IFastListenerList<NotificationListener> notificationListeners() {
        return this.m_listenerList;
    }

    @Override
    public void addNotificationListener(NotificationListener listener) {
        this.notificationListeners().add((Object)listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) {
        this.notificationListeners().remove((Object)listener);
    }

    protected void fireClosed() {
        this.fireNotificationEvent(new NotificationEvent(this, 900));
    }

    protected void fireNotificationEvent(NotificationEvent event) {
        this.notificationListeners().list().forEach(listener -> listener.notificationChanged(event));
    }

    @Override
    public INotificationUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected class P_UIFacade
    implements INotificationUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireClosedFromUI() {
            Notification.this.fireClosed();
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            if (Notification.this.m_appLinkConsumer != null) {
                Notification.this.m_appLinkConsumer.accept(ref);
            }
        }
    }
}

