/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.messagebox;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class MessageBoxes {
    private MessageBoxes() {
    }

    public static IMessageBox create() {
        return (IMessageBox)BEANS.get(IMessageBox.class);
    }

    public static IMessageBox createOk() {
        return MessageBoxes.create().withYesButtonText(TEXTS.get((String)"OkButton"));
    }

    public static IMessageBox createYesNo() {
        return MessageBoxes.create().withYesButtonText(TEXTS.get((String)"YesButton")).withNoButtonText(TEXTS.get((String)"NoButton"));
    }

    public static IMessageBox createYesNoCancel() {
        return MessageBoxes.createYesNo().withCancelButtonText(TEXTS.get((String)"CancelButton"));
    }

    public static boolean showDeleteConfirmationMessage(Object items) {
        return MessageBoxes.showDeleteConfirmationMessage(null, items);
    }

    public static boolean showDeleteConfirmationMessage(Collection<?> items) {
        return MessageBoxes.showDeleteConfirmationMessage(null, items);
    }

    public static boolean showDeleteConfirmationMessage(String itemType, Object items) {
        if (items == null) {
            return MessageBoxes.showDeleteConfirmationMessage(itemType, Collections.emptyList());
        }
        if (items instanceof Object[]) {
            return MessageBoxes.showDeleteConfirmationMessage(itemType, Arrays.asList((Object[])items));
        }
        if (items instanceof Collection) {
            return MessageBoxes.showDeleteConfirmationMessage(itemType, (Collection)items);
        }
        return MessageBoxes.showDeleteConfirmationMessage(itemType, Collections.singletonList(items));
    }

    public static boolean showDeleteConfirmationMessage(String itemType, Collection<?> items) {
        int result = MessageBoxes.createDeleteConfirmationMessage(itemType, items).show();
        return result == 0;
    }

    public static IMessageBox createDeleteConfirmationMessage(Collection<?> items) {
        return MessageBoxes.createDeleteConfirmationMessage(null, items);
    }

    public static IMessageBox createDeleteConfirmationMessage(String itemType, Collection<?> items) {
        boolean hasItems = !CollectionUtility.isEmpty(items);
        String header = null;
        header = itemType != null ? (hasItems ? TEXTS.get((String)"DeleteConfirmationTextX", (String[])new String[]{itemType}) : TEXTS.get((String)"DeleteConfirmationTextNoItemListX", (String[])new String[]{itemType})) : (hasItems ? TEXTS.get((String)"DeleteConfirmationText") : TEXTS.get((String)"DeleteConfirmationTextNoItemList"));
        return MessageBoxes.createYesNo().withHeader(header).withHtml((IHtmlContent)MessageBoxes.createDeleteConfirmationMessageHtml(items));
    }

    private static IHtmlElement createDeleteConfirmationMessageHtml(Collection<?> items) {
        if (CollectionUtility.isEmpty(items)) {
            return null;
        }
        int maxVisibleItemsCount = 10;
        int excessItemsMessageLines = 2;
        int hiddenItemsCount = items.size() - 10;
        boolean showExcessItemsEntry = hiddenItemsCount > 2;
        List elements = items.stream().limit(10 + (showExcessItemsEntry ? 0 : 2)).map(item -> HTML.li((CharSequence)StringUtility.emptyIfNull((Object)item))).collect(Collectors.toList());
        if (showExcessItemsEntry) {
            elements.add(HTML.li((CharSequence)"...  "));
            elements.add(HTML.li((CharSequence)TEXTS.get((String)"XAdditional", (String[])new String[]{Integer.toString(hiddenItemsCount)})));
        }
        return HTML.ul(elements);
    }
}

