/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.messagebox;

import jakarta.annotation.PostConstruct;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.DisplayParentResolver;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBoxUIFacade;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
@ClassId(value="b22a87dc-b40c-4c4f-96cc-356aef66e508")
public class MessageBox
extends AbstractWidget
implements IMessageBox {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBox.class);
    private final FastListenerList<MessageBoxListener> m_listenerList = new FastListenerList();
    private final IMessageBoxUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
    private IDisplayParent m_displayParent;
    private long m_autoCloseMillis = -1L;
    private String m_iconId;
    private String m_header;
    private String m_body;
    private IHtmlContent m_html;
    private String m_yesButtonText;
    private String m_noButtonText;
    private String m_cancelButtonText;
    private String m_hiddenText;
    private String m_copyPasteText;
    private String m_copyPasteTextInternal;
    private final IBlockingCondition m_blockingCondition = Jobs.newBlockingCondition((boolean)false);
    private int m_answer;
    private boolean m_answerSet;
    private int m_severity = 256;

    @Override
    @PostConstruct
    protected void initConfig() {
        super.initConfig();
        this.m_displayParent = ((DisplayParentResolver)BEANS.get(DisplayParentResolver.class)).resolve(this);
    }

    @Override
    protected boolean getConfiguredInheritAccessibility() {
        return false;
    }

    @Override
    public IDisplayParent getDisplayParent() {
        return this.m_displayParent;
    }

    @Override
    public IMessageBox withDisplayParent(IDisplayParent displayParent) {
        Assertions.assertFalse((boolean)ClientSessionProvider.currentSession().getDesktop().isShowing(this), (String)"Property 'displayParent' cannot be changed because message box is already showing [messageBox={}]", (Object[])new Object[]{this});
        if (displayParent == null) {
            displayParent = ((DisplayParentResolver)BEANS.get(DisplayParentResolver.class)).resolve(this);
        }
        this.m_displayParent = (IDisplayParent)Assertions.assertNotNull((Object)displayParent, (String)"'displayParent' must not be null", (Object[])new Object[0]);
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getHeader() {
        return this.m_header;
    }

    @Override
    public MessageBox withHeader(String header) {
        this.m_header = header;
        this.m_copyPasteTextInternal = null;
        return this;
    }

    @Override
    public String getBody() {
        return this.m_body;
    }

    @Override
    public MessageBox withBody(String body) {
        this.m_body = body;
        this.m_copyPasteTextInternal = null;
        return this;
    }

    @Override
    public IHtmlContent getHtml() {
        return this.m_html;
    }

    @Override
    public MessageBox withHtml(IHtmlContent html) {
        this.m_html = html;
        this.m_copyPasteTextInternal = null;
        return this;
    }

    @Override
    public String getHiddenText() {
        return this.m_hiddenText;
    }

    @Override
    public MessageBox withHiddenText(String hiddenText) {
        this.m_hiddenText = hiddenText;
        this.m_copyPasteTextInternal = null;
        return this;
    }

    @Override
    public String getYesButtonText() {
        return this.m_yesButtonText;
    }

    @Override
    public MessageBox withYesButtonText(String yesButtonText) {
        this.m_yesButtonText = yesButtonText;
        return this;
    }

    @Override
    public String getNoButtonText() {
        return this.m_noButtonText;
    }

    @Override
    public MessageBox withNoButtonText(String noButtonText) {
        this.m_noButtonText = noButtonText;
        return this;
    }

    @Override
    public String getCancelButtonText() {
        return this.m_cancelButtonText;
    }

    @Override
    public MessageBox withCancelButtonText(String cancelButtonText) {
        this.m_cancelButtonText = cancelButtonText;
        return this;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public MessageBox withIconId(String iconId) {
        this.m_iconId = iconId;
        return this;
    }

    @Override
    public int getSeverity() {
        return this.m_severity;
    }

    @Override
    public MessageBox withSeverity(int severity) {
        this.m_severity = severity;
        return this;
    }

    @Override
    public long getAutoCloseMillis() {
        return this.m_autoCloseMillis;
    }

    @Override
    public MessageBox withAutoCloseMillis(long autoCloseMillis) {
        this.m_autoCloseMillis = autoCloseMillis;
        return this;
    }

    @Override
    public String getCopyPasteText() {
        if (this.m_copyPasteText == null) {
            this.updateCopyPasteTextInternal();
            return this.m_copyPasteTextInternal;
        }
        return this.m_copyPasteText;
    }

    @Override
    public MessageBox withCopyPasteText(String copyPasteText) {
        this.m_copyPasteText = copyPasteText;
        return this;
    }

    protected void updateCopyPasteTextInternal() {
        if (this.m_copyPasteTextInternal == null) {
            this.m_copyPasteTextInternal = StringUtility.join((String)"\n\n", (Object[])new Object[]{this.m_header, this.m_body, this.m_html == null ? null : ((HtmlHelper)BEANS.get(HtmlHelper.class)).toPlainText(this.m_html.toHtml()), this.m_hiddenText});
        }
    }

    @Override
    public IFastListenerList<MessageBoxListener> messageBoxListeners() {
        return this.m_listenerList;
    }

    protected void fireClosed() {
        this.fireMessageBoxEvent(new MessageBoxEvent(this, 900));
    }

    protected void fireMessageBoxEvent(MessageBoxEvent e) {
        this.messageBoxListeners().list().forEach(listener -> listener.messageBoxChanged(e));
    }

    @Override
    public IMessageBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public boolean isOpen() {
        return this.m_blockingCondition.isBlocking();
    }

    @Override
    public int show() {
        return this.show(2);
    }

    @Override
    public int show(int defaultResult) {
        this.m_answerSet = false;
        this.m_answer = defaultResult;
        if (ClientSessionProvider.currentSession() == null) {
            LOG.warn("outside ScoutSessionThread, default answer is CANCEL", (Throwable)new IllegalStateException());
            this.m_answerSet = true;
            this.m_answer = 2;
            return this.m_answer;
        }
        this.m_blockingCondition.setBlocking(true);
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        try {
            if (desktop == null || !desktop.isOpened()) {
                LOG.warn("there is no desktop or the desktop has not yet been opened in the ui, default answer is CANCEL", (Throwable)new IllegalStateException());
                this.m_answerSet = true;
                this.m_answer = 2;
            } else {
                desktop.showMessageBox(this);
                IFuture autoCloseFuture = null;
                if (this.getAutoCloseMillis() > 0L) {
                    long closeDelay = this.getAutoCloseMillis();
                    autoCloseFuture = Jobs.schedule(this::closeMessageBox, (JobInput)Jobs.newInput().withName("Closing message box", new Object[0]).withRunContext((RunContext)ClientRunContexts.copyCurrent()).withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn(closeDelay, TimeUnit.MILLISECONDS)));
                }
                this.waitFor();
                if (autoCloseFuture != null && !autoCloseFuture.isDone()) {
                    autoCloseFuture.cancel(true);
                }
            }
        }
        finally {
            if (desktop != null) {
                desktop.hideMessageBox(this);
            }
            this.fireClosed();
        }
        return this.m_answer;
    }

    protected void waitFor() {
        this.m_blockingCondition.waitFor(new String[]{"ui.interaction.required"});
    }

    protected void closeMessageBox() {
        this.m_blockingCondition.setBlocking(false);
    }

    @Override
    public void doOk() {
        this.closeInternal(CollectionUtility.arrayList((Object[])new Pair[]{new ImmutablePair((Object)this.m_yesButtonText, (Object)0), new ImmutablePair((Object)this.m_noButtonText, (Object)1), new ImmutablePair((Object)this.m_cancelButtonText, (Object)2)}));
    }

    @Override
    public void doClose() {
        this.closeInternal(CollectionUtility.arrayList((Object[])new Pair[]{new ImmutablePair((Object)this.m_cancelButtonText, (Object)2), new ImmutablePair((Object)this.m_noButtonText, (Object)1), new ImmutablePair((Object)this.m_yesButtonText, (Object)0)}));
    }

    private void closeInternal(List<Pair<String, Integer>> options) {
        if (!this.m_answerSet) {
            this.m_answerSet = true;
            options.stream().filter(option -> StringUtility.hasText((CharSequence)((CharSequence)option.getLeft()))).findFirst().ifPresent(option -> {
                int n = this.m_answer = ((Integer)option.getRight()).intValue();
            });
        }
        this.closeMessageBox();
    }

    protected class P_UIFacade
    implements IMessageBoxUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setResultFromUI(int option) {
            switch (option) {
                case 0: 
                case 1: 
                case 2: {
                    if (!MessageBox.this.m_answerSet) {
                        MessageBox.this.m_answerSet = true;
                        MessageBox.this.m_answer = option;
                    }
                    MessageBox.this.closeMessageBox();
                }
            }
        }
    }
}

