/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.useradmin;

import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.services.common.pwd.IPasswordManagementService;

@ClassId(value="5bcb48f0-9b72-4f28-9c08-038cd5d9a1c4")
public class DefaultPasswordForm
extends AbstractForm {
    private String m_userId;

    public String getUserId() {
        return this.m_userId;
    }

    public void setUserId(String userId) {
        this.m_userId = userId;
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"ChangePassword");
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GroupBox.OldPasswordField getOldPasswordField() {
        return this.getFieldByClass(MainBox.GroupBox.OldPasswordField.class);
    }

    public MainBox.GroupBox.NewPasswordField getNewPasswordField() {
        return this.getFieldByClass(MainBox.GroupBox.NewPasswordField.class);
    }

    public MainBox.GroupBox.RepeatPasswordField getRepeatPasswordField() {
        return this.getFieldByClass(MainBox.GroupBox.RepeatPasswordField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public void startChange() {
        this.startInternal(new ChangeHandler());
    }

    public void startReset() {
        this.startInternal(new ResetHandler());
    }

    protected void resetSessionIfCurrentUser(IPasswordManagementService svc) {
        IClientSession session = (IClientSession)ISession.CURRENT.get();
        String userName = svc.getUsernameFor(this.getUserId());
        String myNameIs = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserIdOfCurrentSubject();
        if (myNameIs.equals(userName)) {
            ModelJobs.schedule(session::stop, ModelJobs.newInput(ClientRunContexts.empty().withSession(session, false)));
        }
    }

    public class ChangeHandler
    extends AbstractFormHandler {
        @Override
        protected void execStore() {
            if (DefaultPasswordForm.this.getNewPasswordField().getValue() != null && !((String)DefaultPasswordForm.this.getNewPasswordField().getValue()).equals(DefaultPasswordForm.this.getRepeatPasswordField().getValue())) {
                throw new VetoException(TEXTS.get((String)"PasswordsDoNotMatch"), new Object[0]);
            }
            IPasswordManagementService svc = (IPasswordManagementService)BEANS.get(IPasswordManagementService.class);
            svc.changePassword(DefaultPasswordForm.this.getUserId(), ((String)DefaultPasswordForm.this.getOldPasswordField().getValue()).toCharArray(), ((String)DefaultPasswordForm.this.getNewPasswordField().getValue()).toCharArray());
            DefaultPasswordForm.this.resetSessionIfCurrentUser(svc);
        }
    }

    @Order(value=20.0)
    @ClassId(value="02df65d9-252a-4c24-a232-27bb0924a1b1")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        @Order(value=50.0)
        @ClassId(value="0a491aaf-cf8d-49ce-91d9-f9e2a5ee86f9")
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=10.0)
        @ClassId(value="b44b8225-ce40-448c-a908-4ef8dc4df876")
        public class GroupBox
        extends AbstractGroupBox {

            @Order(value=20.0)
            @ClassId(value="9fb80aa1-3c3c-4881-8395-7155d69d4425")
            public class NewPasswordField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"NewPassword");
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredInputMasked() {
                    return true;
                }
            }

            @Order(value=10.0)
            @ClassId(value="b27cada2-acb5-4702-a2c5-87e529fb26bc")
            public class OldPasswordField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"OldPassword");
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredInputMasked() {
                    return true;
                }
            }

            @Order(value=30.0)
            @ClassId(value="14d4143c-ceb3-4a3a-8c83-cfeb09b0727f")
            public class RepeatPasswordField
            extends AbstractStringField {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"RepeatPassword");
                }

                @Override
                protected boolean getConfiguredMandatory() {
                    return true;
                }

                @Override
                protected boolean getConfiguredInputMasked() {
                    return true;
                }
            }
        }

        @Order(value=40.0)
        @ClassId(value="d228bd1e-a052-4036-8ca4-7b0ec4ac42ae")
        public class OkButton
        extends AbstractOkButton {
        }
    }

    public class ResetHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() {
            DefaultPasswordForm.this.getOldPasswordField().setMandatory(false);
            DefaultPasswordForm.this.getOldPasswordField().setVisible(false);
        }

        @Override
        protected void execStore() {
            if (DefaultPasswordForm.this.getNewPasswordField().getValue() != null && !((String)DefaultPasswordForm.this.getNewPasswordField().getValue()).equals(DefaultPasswordForm.this.getRepeatPasswordField().getValue())) {
                throw new VetoException(TEXTS.get((String)"PasswordsDoNotMatch"), new Object[0]);
            }
            IPasswordManagementService svc = (IPasswordManagementService)BEANS.get(IPasswordManagementService.class);
            svc.resetPassword(DefaultPasswordForm.this.getUserId(), ((String)DefaultPasswordForm.this.getNewPasswordField().getValue()).toCharArray());
            DefaultPasswordForm.this.resetSessionIfCurrentUser(svc);
        }
    }
}

