/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindFieldByXmlIdsVisitor
implements Consumer<IFormField> {
    private static final Logger LOG = LoggerFactory.getLogger(FindFieldByXmlIdsVisitor.class);
    private final String[] m_xmlFieldIds;
    private final NavigableMap<CompositeObject, IFormField> m_prioMap;
    private final Set<CompositeObject> m_ambiguousFieldKeys;

    public FindFieldByXmlIdsVisitor(String ... xmlFieldIds) {
        this.m_xmlFieldIds = xmlFieldIds;
        this.m_prioMap = new TreeMap<CompositeObject, IFormField>();
        this.m_ambiguousFieldKeys = new HashSet<CompositeObject>();
    }

    @Override
    public void accept(IFormField field) {
        int fieldIdRank = this.getFieldIdRank(field);
        if (fieldIdRank > 0) {
            int enclosingFieldPathRank = this.getEnclosingFieldPathRank(field);
            CompositeObject key = field instanceof IValueField ? new CompositeObject(new Object[]{fieldIdRank, enclosingFieldPathRank, 2}) : (!(field instanceof ICompositeField) ? new CompositeObject(new Object[]{fieldIdRank, enclosingFieldPathRank, 1}) : new CompositeObject(new Object[]{fieldIdRank, enclosingFieldPathRank, 0}));
            if (this.m_prioMap.containsKey(key)) {
                this.m_ambiguousFieldKeys.add(key);
            } else {
                this.m_prioMap.put(key, field);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getFieldIdRank(IFormField f) {
        int i = this.m_xmlFieldIds.length - 1;
        if (!this.m_xmlFieldIds[i].equals(f.getFieldId())) {
            return 0;
        }
        --i;
        f = f.getParentField();
        while (i >= 0 && f != null) {
            if (this.m_xmlFieldIds[i].equals(f.getFieldId())) {
                --i;
            }
            f = f.getParentField();
        }
        return this.m_xmlFieldIds.length - 1 - i;
    }

    private int getEnclosingFieldPathRank(IFormField f) {
        int rank = 0;
        int i = this.m_xmlFieldIds.length - 2;
        List<ICompositeField> enclosingFieldList = f.getEnclosingFieldList();
        Collections.reverse(enclosingFieldList);
        for (ICompositeField p : enclosingFieldList) {
            if (i >= 0 && p.getFieldId().equals(this.m_xmlFieldIds[i])) {
                --i;
                continue;
            }
            --rank;
        }
        return rank;
    }

    public IFormField getField() {
        if (this.m_prioMap.isEmpty()) {
            return null;
        }
        Map.Entry<CompositeObject, IFormField> candidate = this.m_prioMap.lastEntry();
        if (this.m_ambiguousFieldKeys.contains(candidate.getKey()) && Platform.get().inDevelopmentMode()) {
            LOG.warn("ambiguous fieldId: {} returning first candidate [{}]", (Object)this.m_xmlFieldIds, (Object)candidate.getValue());
        }
        return candidate.getValue();
    }
}

