/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.wizard;

import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.wizard.IWizardProgressFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.wizard.WizardProgressFieldChains;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wizard.IWizardProgressField;
import org.eclipse.scout.rt.client.ui.form.fields.wizard.IWizardProgressFieldUIFacade;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.client.ui.wizard.WizardEvent;
import org.eclipse.scout.rt.client.ui.wizard.WizardListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.WeakEventListener;

@ClassId(value="bcaedbdd-221f-438c-b537-80b5c5056eb7")
public abstract class AbstractWizardProgressField
extends AbstractFormField
implements IWizardProgressField {
    private IWizardProgressFieldUIFacade m_uiFacade;
    private final WizardListener m_wizardListener = new P_WizardListener();

    public AbstractWizardProgressField() {
        this(true);
    }

    public AbstractWizardProgressField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
    }

    @Override
    public IWizardProgressFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public IWizard getWizard() {
        if (this.getForm() != null) {
            return this.getForm().getWizard();
        }
        return null;
    }

    @Override
    public List<IWizardStep<? extends IForm>> getSteps() {
        return (List)this.propertySupport.getProperty("steps");
    }

    @Override
    public void setSteps(List<IWizardStep<? extends IForm>> steps) {
        this.propertySupport.setPropertyAlwaysFire("steps", steps);
    }

    @Override
    public IWizardStep<? extends IForm> getActiveStep() {
        return (IWizardStep)this.propertySupport.getProperty("activeStep");
    }

    @Override
    public void setActiveStep(IWizardStep<? extends IForm> activeStep) {
        this.propertySupport.setProperty("activeStep", activeStep);
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridW() {
        return 2;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 0.0;
    }

    @Override
    protected void execInitField() {
        super.execInitField();
        this.installWizard(this.getWizard());
    }

    @Override
    protected void execDisposeField() {
        super.execDisposeField();
        this.uninstallWizard();
    }

    @Order(value=10.0)
    @ConfigOperation
    protected void execStepAction(int stepIndex) {
        IWizardStep step = (IWizardStep)CollectionUtility.getElement(this.getSteps(), (int)stepIndex);
        if (step == null) {
            throw new IllegalStateException("Invalid stepIndex: " + stepIndex);
        }
        step.doAction();
    }

    protected void installWizard(IWizard wizard) {
        this.uninstallWizard();
        if (wizard != null) {
            wizard.addWizardListener(this.m_wizardListener);
            this.handleWizardStateChanged(wizard);
        }
    }

    protected void uninstallWizard() {
        IWizard wizard = this.getWizard();
        if (wizard != null) {
            wizard.removeWizardListener(this.m_wizardListener);
        }
    }

    protected void handleWizardStateChanged(IWizard wizard) {
        if (wizard != null) {
            this.setSteps(wizard.getSteps());
            this.setActiveStep(wizard.getActiveStep());
        }
    }

    protected void handleWizardClosed() {
        this.uninstallWizard();
    }

    protected void interceptStepAction(int stepIndex) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        WizardProgressFieldChains.WizardProgressFieldStepActionChain chain = new WizardProgressFieldChains.WizardProgressFieldStepActionChain(extensions);
        chain.execStepIndex(stepIndex);
    }

    protected IWizardProgressFieldExtension<? extends AbstractWizardProgressField> createLocalExtension() {
        return new LocalWizardProgressFieldExtension<AbstractWizardProgressField>(this);
    }

    protected static class LocalWizardProgressFieldExtension<OWNER extends AbstractWizardProgressField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IWizardProgressFieldExtension<OWNER> {
        public LocalWizardProgressFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execStepAction(WizardProgressFieldChains.WizardProgressFieldStepActionChain wizardProgressFieldStepActionChain, int stepIndex) {
            ((AbstractWizardProgressField)this.getOwner()).execStepAction(stepIndex);
        }
    }

    protected class P_UIFacade
    implements IWizardProgressFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void stepActionFromUI(int stepIndex) {
            if (!AbstractWizardProgressField.this.isEnabledIncludingParents() || !AbstractWizardProgressField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractWizardProgressField.this.interceptStepAction(stepIndex);
        }
    }

    private class P_WizardListener
    implements WizardListener,
    WeakEventListener {
        private P_WizardListener() {
        }

        @Override
        public void wizardChanged(WizardEvent e) {
            if (e.getType() == 10) {
                AbstractWizardProgressField.this.handleWizardStateChanged(e.getWizard());
            } else if (e.getType() == 50) {
                AbstractWizardProgressField.this.handleWizardClosed();
            }
        }
    }
}

