/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.treebox;

import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@ClassId(value="3c7ec46e-1f1b-4e1f-a65e-cdf24505c12a")
public abstract class AbstractTreeBoxFilterBox
extends AbstractGroupBox {
    private final OptimisticLock m_treeBoxSyncLock = new OptimisticLock();
    private PropertyChangeListener m_treeBoxPropertyListener;

    public AbstractTreeBoxFilterBox() {
        this(true);
    }

    public AbstractTreeBoxFilterBox(boolean callInitializer) {
        super(callInitializer);
    }

    protected abstract ITreeBox getTreeBox();

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected void execInitField() {
        if (this.m_treeBoxPropertyListener == null) {
            this.m_treeBoxPropertyListener = e -> {
                String name = e.getPropertyName();
                if ("filterCheckedNodes".equals(name)) {
                    this.updateVisibilities();
                    return;
                }
                if ("filterActiveNodes".equals(name)) {
                    this.updateVisibilities();
                    return;
                }
                if ("filterCheckedNodesValue".equals(name)) {
                    try {
                        if (!this.m_treeBoxSyncLock.acquire()) return;
                        this.getCheckedStateRadioButtonGroup().setValue(this.getTreeBox().getFilterCheckedNodesValue());
                        return;
                    }
                    finally {
                        this.m_treeBoxSyncLock.release();
                    }
                }
                if (!"filterActiveNodesValue".equals(name)) return;
                try {
                    if (!this.m_treeBoxSyncLock.acquire()) return;
                    this.getActiveStateRadioButtonGroup().setValue(this.getTreeBox().getFilterActiveNodesValue());
                    return;
                }
                finally {
                    this.m_treeBoxSyncLock.release();
                }
            };
            this.getTreeBox().addPropertyChangeListener(this.m_treeBoxPropertyListener);
        }
        try {
            this.m_treeBoxSyncLock.acquire();
            this.updateVisibilities();
            this.getCheckedStateRadioButtonGroup().setValue(this.getTreeBox().getFilterCheckedNodesValue());
            this.getActiveStateRadioButtonGroup().setValue(this.getTreeBox().getFilterActiveNodesValue());
        }
        finally {
            this.m_treeBoxSyncLock.release();
        }
    }

    protected void updateVisibilities() {
        this.setVisible(this.getTreeBox().isFilterCheckedNodes() || this.getTreeBox().isFilterActiveNodes());
        this.getCheckedStateRadioButtonGroup().setVisible(this.getTreeBox().isFilterCheckedNodes());
        this.getActiveStateRadioButtonGroup().setVisible(this.getTreeBox().isFilterActiveNodes());
    }

    @Override
    protected void execDisposeField() {
        if (this.m_treeBoxPropertyListener != null) {
            this.getTreeBox().removePropertyChangeListener(this.m_treeBoxPropertyListener);
            this.m_treeBoxPropertyListener = null;
        }
    }

    public ActiveStateRadioButtonGroup getActiveStateRadioButtonGroup() {
        return this.getFieldByClass(ActiveStateRadioButtonGroup.class);
    }

    public CheckedStateRadioButtonGroup getCheckedStateRadioButtonGroup() {
        return this.getFieldByClass(CheckedStateRadioButtonGroup.class);
    }

    @Order(value=20.0)
    @ClassId(value="36299662-6bd3-47e2-b3bc-9d54be265de4")
    public class ActiveStateRadioButtonGroup
    extends AbstractRadioButtonGroup<TriState> {
        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected double getConfiguredGridWeightX() {
            return 1.0;
        }

        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() {
            return false;
        }

        @Override
        protected void execChangedValue() {
            try {
                if (AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.acquire()) {
                    AbstractTreeBoxFilterBox.this.getTreeBox().setFilterActiveNodesValue((TriState)AbstractTreeBoxFilterBox.this.getActiveStateRadioButtonGroup().getValue());
                }
            }
            finally {
                AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.release();
            }
        }

        @Order(value=30.0)
        @ClassId(value="773e2eaf-71e1-4619-84aa-f38754e73dfd")
        public class ActiveAndInactiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"ActiveAndInactiveStates");
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.UNDEFINED;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        @ClassId(value="fddfd6c9-882e-44bc-aa23-f6b5e1234168")
        public class ActiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"ActiveStates");
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.TRUE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=20.0)
        @ClassId(value="67948fb1-014e-4557-a30d-cb6250ae6154")
        public class InactiveButton
        extends AbstractRadioButton<TriState> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"InactiveStates");
            }

            @Override
            protected TriState getConfiguredRadioValue() {
                return TriState.FALSE;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    @ClassId(value="a292b6e6-0e77-4852-a346-dc27f72b9f57")
    public class CheckedStateRadioButtonGroup
    extends AbstractRadioButtonGroup<Boolean> {
        @Override
        protected void execAddSearchTerms(SearchFilter search) {
        }

        @Override
        protected boolean getConfiguredGridUseUiHeight() {
            return true;
        }

        @Override
        protected boolean getConfiguredGridUseUiWidth() {
            return true;
        }

        @Override
        protected double getConfiguredGridWeightX() {
            return 1.0;
        }

        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected boolean execIsEmpty() {
            return true;
        }

        @Override
        protected boolean execIsSaveNeeded() {
            return false;
        }

        @Override
        protected void execChangedValue() {
            try {
                if (AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.acquire()) {
                    Boolean b = (Boolean)AbstractTreeBoxFilterBox.this.getCheckedStateRadioButtonGroup().getValue();
                    AbstractTreeBoxFilterBox.this.getTreeBox().setFilterCheckedNodesValue(b != null && b != false);
                }
            }
            finally {
                AbstractTreeBoxFilterBox.this.m_treeBoxSyncLock.release();
            }
        }

        @Order(value=20.0)
        @ClassId(value="d434f8ad-3800-46ac-b0fd-c3fd46d64095")
        public class AllButton
        extends AbstractRadioButton<Boolean> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"AllStates");
            }

            @Override
            protected Boolean getConfiguredRadioValue() {
                return false;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }

        @Order(value=10.0)
        @ClassId(value="356f3fa3-6b10-4b1c-a708-aa33c24fb353")
        public class CheckedButton
        extends AbstractRadioButton<Boolean> {
            @Override
            protected void execAddSearchTerms(SearchFilter search) {
            }

            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"SelectedStates");
            }

            @Override
            protected Boolean getConfiguredRadioValue() {
                return true;
            }

            @Override
            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }
}

