/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tilefield;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tilefield.ITileFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tilefield.TileFieldChains;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.tilefield.ITileField;
import org.eclipse.scout.rt.client.ui.form.fields.tilefield.ITileFieldUIFacade;
import org.eclipse.scout.rt.client.ui.tile.ITile;
import org.eclipse.scout.rt.client.ui.tile.ITileGrid;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="ee6298ff-ef88-4abd-bae0-f5764f6344d8")
public abstract class AbstractTileField<T extends ITileGrid<? extends ITile>>
extends AbstractFormField
implements ITileField<T> {
    private ITileFieldUIFacade<T> m_uiFacade;

    public AbstractTileField() {
        this(true);
    }

    public AbstractTileField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setTileGrid(this.createTileGrid());
        this.setDropMaximumSize(this.getConfiguredDropMaximumSize());
        this.setDropType(this.getConfiguredDropType());
        this.setDragType(this.getConfiguredDragType());
    }

    protected T createTileGrid() {
        List contributedFields = this.m_contributionHolder.getContributionsByClass(ITileGrid.class);
        ITileGrid result = (ITileGrid)CollectionUtility.firstElement((List)contributedFields);
        if (result != null) {
            return (T)result;
        }
        Class<ITileGrid> configuredTileGrid = this.getConfiguredTileGrid();
        if (configuredTileGrid != null) {
            return (T)((ITileGrid)ConfigurationUtility.newInnerInstance((Object)this, configuredTileGrid));
        }
        return null;
    }

    private Class<? extends ITileGrid> getConfiguredTileGrid() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, ITileGrid.class);
    }

    @ConfigProperty(value="LONG")
    @Order(value=10.0)
    protected long getConfiguredDropMaximumSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=20.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=30.0)
    protected int getConfiguredDragType() {
        return 0;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getTileGrid())});
    }

    @Override
    public T getTileGrid() {
        return (T)((ITileGrid)this.propertySupport.getProperty("tileGrid"));
    }

    @Override
    public void setTileGrid(T tiles) {
        T oldTileGrid = this.getTileGrid();
        if (oldTileGrid == tiles) {
            return;
        }
        if (oldTileGrid != null) {
            oldTileGrid.setParentInternal(null);
        }
        this.propertySupport.setProperty("tileGrid", tiles);
        if (tiles != null) {
            tiles.setParentInternal(this);
        }
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.propertySupport.setPropertyLong("dropMaximumSize", dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.propertySupport.getPropertyInt("dropMaximumSize");
    }

    @Override
    protected int getConfiguredGridH() {
        return 3;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected boolean execIsEmpty() {
        if (!super.execIsEmpty()) {
            return false;
        }
        return this.getTileGrid().getTiles().isEmpty();
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDropRequest(TransferObject transferObject) {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected TransferObject execDragRequest() {
        return null;
    }

    @Override
    public ITileFieldUIFacade<T> getUIFacade() {
        return this.m_uiFacade;
    }

    protected ITileFieldExtension<T, ? extends AbstractTileField> createLocalExtension() {
        return new LocalTileFieldExtension(this);
    }

    protected final TransferObject interceptDragRequest() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TileFieldChains.TileFieldDragRequestChain chain = new TileFieldChains.TileFieldDragRequestChain(extensions);
        return chain.execDragRequest();
    }

    protected final void interceptDropRequest(TransferObject transferObject) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TileFieldChains.TileFieldDropRequestChain chain = new TileFieldChains.TileFieldDropRequestChain(extensions);
        chain.execDropRequest(transferObject);
    }

    protected static class LocalTileFieldExtension<T extends ITileGrid<? extends ITile>, OWNER extends AbstractTileField<T>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements ITileFieldExtension<T, OWNER> {
        public LocalTileFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public TransferObject execDragRequest(TileFieldChains.TileFieldDragRequestChain chain) {
            return ((AbstractTileField)this.getOwner()).execDragRequest();
        }

        @Override
        public void execDropRequest(TileFieldChains.TileFieldDropRequestChain chain, TransferObject transferObject) {
            ((AbstractTileField)this.getOwner()).execDropRequest(transferObject);
        }
    }

    protected class P_UIFacade
    implements ITileFieldUIFacade<T> {
        protected P_UIFacade() {
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            TransferObject t = null;
            t = AbstractTileField.this.interceptDragRequest();
            return t;
        }

        @Override
        public void fireDropActionFromUI(TransferObject scoutTransferable) {
            if (!AbstractTileField.this.isEnabledIncludingParents() || !AbstractTileField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractTileField.this.interceptDropRequest(scoutTransferable);
        }
    }
}

