/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tagfield;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallResult;
import org.eclipse.scout.rt.client.services.lookup.IQueryParam;
import org.eclipse.scout.rt.client.services.lookup.LookupCallResult;
import org.eclipse.scout.rt.client.services.lookup.QueryParam;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.tagfield.ITagField;
import org.eclipse.scout.rt.client.ui.form.fields.tagfield.ITagFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRowFetchedCallback;

@ClassId(value="c3e4f668-d55b-4748-b21d-8c539c25501a")
public abstract class AbstractTagField
extends AbstractValueField<Set<String>>
implements ITagField {
    private ITagFieldUIFacade m_uiFacade;
    private ILookupCall<String> m_lookupCall;
    private IFuture<Void> m_runningLookup;

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.setMaxLength(this.getConfiguredMaxLength());
        Class<? extends ILookupCall<String>> lookupCallClass = this.getConfiguredLookupCall();
        if (lookupCallClass != null) {
            this.setLookupCall((ILookupCall<String>)((ILookupCall)BEANS.get(lookupCallClass)));
        }
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=330.0)
    protected int getConfiguredMaxLength() {
        return 500;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=250.0)
    protected Class<? extends ILookupCall<String>> getConfiguredLookupCall() {
        return null;
    }

    @Override
    protected String formatValueInternal(Set<String> value) {
        return "";
    }

    @Override
    public void addTag(String tag) {
        if (StringUtility.isNullOrEmpty((CharSequence)tag)) {
            return;
        }
        Set<String> tags = this.getOrCreateValue();
        if (tags.contains(tag)) {
            return;
        }
        Set<String> newTags = this.newSet(tags);
        newTags.add(tag);
        this.setValue(newTags);
    }

    protected Set<String> newSet(Collection<String> tags) {
        return new LinkedHashSet<String>(tags);
    }

    protected Set<String> getOrCreateValue() {
        Set<String> value = (Set<String>)this.getValue();
        if (value == null) {
            value = this.newSet(Collections.emptySet());
        }
        return value;
    }

    @Override
    public void setTags(Collection<String> tags) {
        Set<String> tagSet;
        if (tags == null) {
            tags = Collections.emptySet();
        }
        if ((tagSet = this.newSet(tags)).equals(this.getOrCreateValue())) {
            return;
        }
        this.setValue(tagSet);
    }

    @Override
    public void removeTag(String tag) {
        if (StringUtility.isNullOrEmpty((CharSequence)tag)) {
            return;
        }
        Set<String> tags = this.getOrCreateValue();
        if (!tags.contains(tag)) {
            return;
        }
        Set<String> newTags = this.newSet(tags);
        newTags.remove(tag);
        this.setValue(newTags);
    }

    @Override
    public void removeAllTags() {
        this.setTags(null);
    }

    @Override
    public void setMaxLength(int maxLength) {
        boolean changed = this.propertySupport.setPropertyInt("maxLength", Math.max(0, maxLength));
        if (changed && this.isInitConfigDone()) {
            this.setValue((Set)this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        return this.propertySupport.getPropertyInt("maxLength");
    }

    @Override
    public void lookupByText(String text) {
        if (this.m_lookupCall == null) {
            return;
        }
        if (this.m_runningLookup != null) {
            this.m_runningLookup.cancel(false);
        }
        P_LookupByTextCallback callback = new P_LookupByTextCallback(text);
        this.m_lookupCall.setText(text);
        this.m_runningLookup = this.m_lookupCall.getDataByTextInBackground((RunContext)ClientRunContexts.copyCurrent(), (ILookupRowFetchedCallback)callback);
    }

    public ILookupCall<String> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public ILookupCallResult<String> getResult() {
        return (ILookupCallResult)this.propertySupport.getProperty("result");
    }

    public void setResult(ILookupCallResult<String> result) {
        this.propertySupport.setProperty("result", result);
    }

    protected void setLookupCall(ILookupCall<String> lookupCall) {
        this.m_lookupCall = lookupCall;
    }

    @Override
    public ITagFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected class P_LookupByTextCallback
    implements ILookupRowFetchedCallback<String> {
        private final IQueryParam<String> m_queryParam;

        public P_LookupByTextCallback(String text) {
            this.m_queryParam = QueryParam.createByText(text);
        }

        public void onSuccess(List<? extends ILookupRow<String>> lookupRows) {
            try {
                ClientRunContext runContext = ClientRunContexts.copyCurrent();
                if (runContext.getRunMonitor().isCancelled()) {
                    return;
                }
                ModelJobs.schedule(() -> AbstractTagField.this.setResult(new LookupCallResult<String>(lookupRows, this.m_queryParam, null)), ModelJobs.newInput(runContext).withName("Updating {}", new Object[]{AbstractTagField.this.getClass().getName()})).awaitDone();
            }
            catch (ThreadInterruptedError threadInterruptedError) {
                // empty catch block
            }
        }

        public void onFailure(RuntimeException exception) {
        }
    }

    protected class P_UIFacade
    implements ITagFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setValueFromUI(Set<String> value) {
            if (!AbstractTagField.this.isEnabledIncludingParents() || !AbstractTagField.this.isVisibleIncludingParents()) {
                return;
            }
            Set ensuredValue = value.stream().map(this::ensureMaxLength).collect(Collectors.toCollection(LinkedHashSet::new));
            AbstractTagField.this.setValue(ensuredValue);
        }

        @Override
        public void lookupByTextFromUI(String text) {
            if (!AbstractTagField.this.isEnabledIncludingParents() || !AbstractTagField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractTagField.this.lookupByText(this.ensureMaxLength(text));
        }

        protected String ensureMaxLength(String value) {
            return StringUtility.substring((String)value, (int)0, (int)AbstractTagField.this.getMaxLength());
        }
    }
}

