/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tablefield;

import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class ValidateTableFieldDescriptor
extends AbstractValidateContentDescriptor {
    private final ITableField<?> m_tableField;
    private ITableRow m_row;
    private IColumn<?> m_col;

    public ValidateTableFieldDescriptor(ITableField<?> tableField) {
        this.m_tableField = tableField;
    }

    public ITableRow getRow() {
        return this.m_row;
    }

    public void setRow(ITableRow row) {
        this.m_row = row;
    }

    public IColumn<?> getColumn() {
        return this.m_col;
    }

    public void setColumn(IColumn<?> col) {
        this.m_col = col;
    }

    @Override
    public String getDisplayText() {
        String displayText = super.getDisplayText();
        if (StringUtility.isNullOrEmpty((CharSequence)displayText)) {
            return this.m_tableField.getFullyQualifiedLabel(" > ");
        }
        return displayText;
    }

    @Override
    public IStatus getErrorStatus() {
        return this.m_tableField.getErrorStatus();
    }

    @Override
    protected void activateProblemLocationDefault() {
        this.selectAllParentTabsOf(this.m_tableField);
        ITableRow row = this.getRow();
        IColumn<?> col = this.getColumn();
        if (row != null && col != null) {
            this.m_tableField.getTable().requestFocusInCell(col, row);
        }
    }
}

