/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tabbox;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tabbox.ITabBoxExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.tabbox.TabBoxChains;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBoxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.internal.TabBoxGrid;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="14555c41-2d65-414a-94b1-d4328cbd818c")
public abstract class AbstractTabBox
extends AbstractCompositeField
implements ITabBox {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTabBox.class);
    private ITabBoxUIFacade m_uiFacade;
    private TabBoxGrid m_grid;

    public AbstractTabBox() {
        this(true);
    }

    public AbstractTabBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected int getConfiguredGridW() {
        return 0;
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execTabSelected(IGroupBox selectedBox) {
    }

    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMarkStrategy() {
        return 0;
    }

    @ConfigProperty(value="STRING")
    protected String getConfiguredTabAreaStyle() {
        return "default";
    }

    @Override
    public int getMarkStrategy() {
        return this.propertySupport.getPropertyInt("markStrategy");
    }

    @Override
    public void setMarkStrategy(int markStrategy) {
        this.propertySupport.setPropertyInt("markStrategy", markStrategy);
    }

    @Override
    public String getTabAreaStyle() {
        return this.propertySupport.getPropertyString("tabAreaStyle");
    }

    @Override
    public void setTabAreaStyle(String tabAreaStyle) {
        this.propertySupport.setPropertyString("tabAreaStyle", tabAreaStyle);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_grid = new TabBoxGrid();
        this.setMarkStrategy(this.getConfiguredMarkStrategy());
        this.setTabAreaStyle(this.getConfiguredTabAreaStyle());
        super.initConfig();
    }

    @Override
    protected void initConfigInternal() {
        super.initConfigInternal();
        this.addPropertyChangeListener("selectedTab", e -> this.interceptTabSelected(this.getSelectedTab()));
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_grid.validate(this);
        if (this.isInitConfigDone() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    public TabBoxGrid getFieldGrid() {
        return this.m_grid;
    }

    @Override
    protected void handleChildFieldVisibilityChanged() {
        super.handleChildFieldVisibilityChanged();
        if (this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
        if (this.hasVisibleFieldsInternal()) {
            this.setSelectedTab(this.findNewSelectedTab(this.getSelectedTab()));
        } else {
            this.setSelectedTab(null);
        }
    }

    protected IGroupBox findNewSelectedTab(IGroupBox selectedBox) {
        block7: {
            IGroupBox box;
            block6: {
                if (selectedBox != null) break block6;
                for (IGroupBox box2 : this.getGroupBoxes()) {
                    if (!box2.isVisible()) continue;
                    return box2;
                }
                break block7;
            }
            if (selectedBox.isVisible()) break block7;
            int index = this.getFieldIndex(selectedBox);
            List<IGroupBox> boxes = this.getGroupBoxes();
            int i = index + 1;
            while (i < boxes.size()) {
                box = boxes.get(i);
                if (box.isVisible()) {
                    return box;
                }
                ++i;
            }
            if (this.getSelectedTab() == selectedBox) {
                i = index - 1;
                while (i >= 0) {
                    box = boxes.get(i);
                    if (box.isVisible()) {
                        return box;
                    }
                    --i;
                }
            }
        }
        return selectedBox;
    }

    @Override
    public List<IGroupBox> getGroupBoxes() {
        ArrayList<IGroupBox> result = new ArrayList<IGroupBox>();
        for (IFormField field : this.getFields()) {
            if (field instanceof IGroupBox) {
                result.add((IGroupBox)field);
                continue;
            }
            LOG.warn("TabBoxes only allow instance of IGroupBox as inner fields. '{}' is not instance of IGroupBox!", (Object)field.getClass().getName());
        }
        return result;
    }

    @Override
    public void setSelectedTab(IGroupBox box) {
        if (box == null || box.getParentField() == this) {
            this.propertySupport.setProperty("selectedTab", (Object)box);
        }
    }

    @Override
    public IGroupBox getSelectedTab() {
        return (IGroupBox)this.propertySupport.getProperty("selectedTab");
    }

    @Override
    public ITabBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected final void interceptTabSelected(IGroupBox selectedBox) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        TabBoxChains.TabBoxTabSelectedChain chain = new TabBoxChains.TabBoxTabSelectedChain(extensions);
        chain.execTabSelected(selectedBox);
    }

    @Override
    protected ITabBoxExtension<? extends AbstractTabBox> createLocalExtension() {
        return new LocalTabBoxExtension<AbstractTabBox>(this);
    }

    @Override
    public void removeField(IFormField f) {
        super.removeField(f);
        if (f == this.getSelectedTab()) {
            this.setSelectedTab(this.findNewSelectedTab(null));
        }
    }

    @Override
    public void addField(IFormField f) {
        super.addField(f);
        this.setSelectedTab(this.findNewSelectedTab(null));
    }

    protected static class LocalTabBoxExtension<OWNER extends AbstractTabBox>
    extends AbstractCompositeField.LocalCompositeFieldExtension<OWNER>
    implements ITabBoxExtension<OWNER> {
        public LocalTabBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execTabSelected(TabBoxChains.TabBoxTabSelectedChain chain, IGroupBox selectedBox) {
            ((AbstractTabBox)this.getOwner()).execTabSelected(selectedBox);
        }
    }

    protected class P_UIFacade
    implements ITabBoxUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setSelectedTabFromUI(IGroupBox box) {
            AbstractTabBox.this.setSelectedTab(box);
        }
    }
}

