/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.stringfield;

import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.stringfield.IStringFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.stringfield.StringFieldChains;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="d8b1f73a-4415-4477-8408-e6ada9e69551")
public abstract class AbstractStringField
extends AbstractBasicField<String>
implements IStringField {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStringField.class);
    private IStringFieldUIFacade m_uiFacade;
    private boolean m_enabledProcessing = true;

    public AbstractStringField() {
        this(true);
    }

    public AbstractStringField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected IStringFieldExtension<? extends AbstractStringField> createLocalExtension() {
        return new LocalStringFieldExtension<AbstractStringField>(this);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredHasAction() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=240.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredFormatLower() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=290.0)
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    protected boolean getConfiguredFormatUpper() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredTrimText() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    protected boolean getConfiguredWrapText() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=330.0)
    protected String getConfiguredValueFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=340.0)
    protected boolean getConfiguredSelectionTrackingEnabled() {
        return false;
    }

    @ConfigProperty(value="LONG")
    @Order(value=190.0)
    protected long getConfiguredDropMaximumSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=400.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=410.0)
    protected final int getConfiguredDragType() {
        return 0;
    }

    @ConfigOperation
    @Order(value=500.0)
    protected final TransferObject execDragRequest() {
        return null;
    }

    @ConfigOperation
    @Order(value=510.0)
    protected void execDropRequest(TransferObject transferObject) {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execAction() {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setInputMasked(this.getConfiguredInputMasked());
        super.initConfig();
        if (this.getConfiguredFormatLower()) {
            this.setFormatLower();
        } else if (this.getConfiguredFormatUpper()) {
            this.setFormatUpper();
        } else {
            this.setFormat(this.getConfiguredFormat());
        }
        this.setHasAction(this.getConfiguredHasAction());
        this.setWrapText(this.getConfiguredWrapText());
        this.setTrimText(this.getConfiguredTrimText());
        this.setMultilineText(this.getConfiguredMultilineText());
        int configuredDragType = this.getConfiguredDragType();
        if (4 == configuredDragType) {
            LOG.warn("Drag and drop TextTransfer is default behaviour (Configuration will not be considered).");
            configuredDragType = 0;
        }
        this.setDragType(configuredDragType);
        int configuredDropType = this.getConfiguredDropType();
        if (4 == configuredDropType) {
            LOG.warn("Drag and drop TextTransfer is default behaviour (Configuration will not be considered).");
            configuredDropType = 0;
        }
        this.setDropType(configuredDropType);
        this.setDropMaximumSize(this.getConfiguredDropMaximumSize());
        this.setSelectionTrackingEnabled(this.getConfiguredSelectionTrackingEnabled());
        this.select(-1, -1);
        this.setSpellCheckEnabled(this.computeSpellCheckEnabled());
    }

    @Override
    public void setMaxLength(int maxLength) {
        boolean changed = this.propertySupport.setPropertyInt("maxLength", Math.max(0, maxLength));
        if (changed && this.isInitConfigDone()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        return this.propertySupport.getPropertyInt("maxLength");
    }

    @Override
    protected String validateValueInternal(String rawValue) {
        String validValue = super.validateValueInternal(rawValue);
        if (validValue != null) {
            if (this.isTrimText()) {
                validValue = validValue.trim();
            }
            if (validValue.length() > this.getMaxLength()) {
                validValue = validValue.substring(0, this.getMaxLength());
                if (this.isTrimText()) {
                    validValue = validValue.trim();
                }
            }
            if (this.isFormatUpper()) {
                validValue = validValue.toUpperCase();
            } else if (this.isFormatLower()) {
                validValue = validValue.toLowerCase();
            }
        }
        if (validValue != null && !this.isMultilineText()) {
            validValue = StringUtility.trimNewLines((String)validValue);
            validValue = validValue.replaceAll("\r\n", " ").replaceAll("[\r\n]", " ");
        }
        return StringUtility.nullIfEmpty((Object)validValue);
    }

    @Override
    public void setInputMasked(boolean b) {
        this.propertySupport.setPropertyBool("inputMasked", b);
    }

    @Override
    public boolean isInputMasked() {
        return this.propertySupport.getPropertyBool("inputMasked");
    }

    @Override
    public void setFormatUpper() {
        this.setFormat("A");
    }

    @Override
    public boolean isFormatUpper() {
        return "A".equals(this.getFormat());
    }

    @Override
    public void setFormatLower() {
        this.setFormat("a");
    }

    @Override
    public boolean isFormatLower() {
        return "a".equals(this.getFormat());
    }

    @Override
    public void setHasAction(boolean b) {
        this.propertySupport.setPropertyBool("hasAction", b);
    }

    @Override
    public boolean isHasAction() {
        return this.propertySupport.getPropertyBool("hasAction");
    }

    @Override
    public void setWrapText(boolean b) {
        this.propertySupport.setPropertyBool("wrapText", b);
    }

    @Override
    public boolean isWrapText() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public void setTrimText(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("trimText", b);
        if (b & changed && this.isInitConfigDone()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public boolean isTrimText() {
        return this.propertySupport.getPropertyBool("trimText");
    }

    @Override
    public void setMultilineText(boolean b) {
        boolean changed;
        if (!b & (changed = this.propertySupport.setPropertyBool("multilineText", b)) && this.isInitConfigDone()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public void insertText(String s) {
        this.propertySupport.setPropertyAlwaysFire("insertText", (Object)s);
    }

    @Override
    public void select(int startIndex, int endIndex) {
        try {
            this.propertySupport.setPropertiesChanging(true);
            this.propertySupport.setPropertyInt("selectionStart", startIndex);
            this.propertySupport.setPropertyInt("selectionEnd", endIndex);
        }
        finally {
            this.propertySupport.setPropertiesChanging(false);
        }
    }

    @Override
    public void selectAll() {
        this.select(0, this.getDisplayText().length());
    }

    @Override
    public int getSelectionStart() {
        return this.propertySupport.getPropertyInt("selectionStart");
    }

    @Override
    public int getSelectionEnd() {
        return this.propertySupport.getPropertyInt("selectionEnd");
    }

    @Override
    public boolean isSelectionTrackingEnabled() {
        return this.propertySupport.getPropertyBool("selectionTrackingEnabled");
    }

    @Override
    public void setSelectionTrackingEnabled(boolean selectionTrackingEnabled) {
        this.propertySupport.setPropertyBool("selectionTrackingEnabled", selectionTrackingEnabled);
    }

    @Override
    public IStringFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setFormat(String s) {
        this.propertySupport.setPropertyString("format", s);
        this.refreshDisplayText();
    }

    @Override
    public String getFormat() {
        return this.propertySupport.getPropertyString("format");
    }

    @Override
    protected String parseValueInternal(String text) {
        String fmt;
        if (text != null && text.isEmpty()) {
            text = null;
        }
        if ((fmt = this.getFormat()) != null && text != null) {
            if ("a".equals(fmt)) {
                text = text.toLowerCase();
            } else if ("A".equals(fmt)) {
                text = text.toUpperCase();
            }
        }
        return text;
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.propertySupport.setPropertyLong("dropMaximumSize", dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.propertySupport.getPropertyInt("dropMaximumSize");
    }

    @Override
    public boolean isEnabledProcessing() {
        return this.m_enabledProcessing;
    }

    private void setEnabledProcessing(boolean b) {
        this.m_enabledProcessing = b;
    }

    @Override
    public void doAction() {
        if (this.isHasAction() && this.isEnabled() && this.isVisible() && this.isEnabledProcessing()) {
            try {
                this.setEnabledProcessing(false);
                this.interceptAction();
            }
            finally {
                this.setEnabledProcessing(true);
            }
        }
    }

    protected boolean computeSpellCheckEnabled() {
        return !this.isHasAction() && !this.isFormatUpper() && !this.isFormatLower() && this.isMultilineText();
    }

    @Override
    public void setSpellCheckEnabled(boolean spellCheckEnabled) {
        this.propertySupport.setPropertyBool("spellCheckEnabled", spellCheckEnabled);
    }

    @Override
    public boolean isSpellCheckEnabled() {
        return this.propertySupport.getPropertyBool("spellCheckEnabled");
    }

    protected final void interceptDropRequest(TransferObject transferObject) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        StringFieldChains.StringFieldDropRequestChain chain = new StringFieldChains.StringFieldDropRequestChain(extensions);
        chain.execDropRequest(transferObject);
    }

    protected final void interceptAction() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        StringFieldChains.StringFieldLinkActionChain chain = new StringFieldChains.StringFieldLinkActionChain(extensions);
        chain.execAction();
    }

    protected final TransferObject interceptDragRequest() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        StringFieldChains.StringFieldDragRequestChain chain = new StringFieldChains.StringFieldDragRequestChain(extensions);
        return chain.execDragRequest();
    }

    protected static class LocalStringFieldExtension<OWNER_FIELD extends AbstractStringField>
    extends AbstractBasicField.LocalBasicFieldExtension<String, OWNER_FIELD>
    implements IStringFieldExtension<OWNER_FIELD> {
        public LocalStringFieldExtension(OWNER_FIELD owner) {
            super(owner);
        }

        @Override
        public void execDropRequest(StringFieldChains.StringFieldDropRequestChain chain, TransferObject transferObject) {
            ((AbstractStringField)this.getOwner()).execDropRequest(transferObject);
        }

        @Override
        public void execAction(StringFieldChains.StringFieldLinkActionChain chain) {
            ((AbstractStringField)this.getOwner()).execAction();
        }

        @Override
        public TransferObject execDragRequest(StringFieldChains.StringFieldDragRequestChain chain) {
            return ((AbstractStringField)this.getOwner()).execDragRequest();
        }
    }

    protected class P_UIFacade
    extends AbstractBasicField.P_UIFacade
    implements IStringFieldUIFacade {
        protected P_UIFacade() {
            super(AbstractStringField.this);
        }

        @Override
        public void fireActionFromUI() {
            if (!AbstractStringField.this.isEnabledIncludingParents() || !AbstractStringField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractStringField.this.doAction();
        }

        @Override
        public void setSelectionFromUI(int startOfSelection, int endOfSelection) {
            if (!AbstractStringField.this.isEnabledIncludingParents() || !AbstractStringField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractStringField.this.select(startOfSelection, endOfSelection);
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            return AbstractStringField.this.interceptDragRequest();
        }

        @Override
        public void fireDropActionFromUi(TransferObject scoutTransferable) {
            if (!AbstractStringField.this.isEnabledIncludingParents() || !AbstractStringField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractStringField.this.interceptDropRequest(scoutTransferable);
        }
    }
}

