/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.splitbox.internal;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeFieldGrid;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;

public class SplitBoxGrid
implements ICompositeFieldGrid<ISplitBox> {
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    @Override
    public void validate(ISplitBox splitBox) {
        this.m_gridColumns = 2;
        this.m_gridRows = 1;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        for (IFormField f : splitBox.getFields()) {
            if (f.isVisible()) {
                list.add(f);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(f, 1);
            f.setGridDataInternal(data);
        }
        this.m_fields = list.toArray(new IFormField[0]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        int x = 0;
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField m_field = iFormFieldArray[n2];
            GridData data = GridDataBuilder.createFromHints(m_field, 1);
            data.x = x;
            data.y = 0;
            if (data.weightX < 0.0) {
                data.weightX = data.w;
            }
            m_field.setGridDataInternal(data);
            x += data.w;
            this.m_gridRows = Math.max(this.m_gridRows, data.h);
            ++n2;
        }
        this.m_gridColumns = x;
    }

    @Override
    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    @Override
    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

