/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.splitbox;

import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.splitbox.ISplitBoxExtension;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBoxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.internal.SplitBoxGrid;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="2b156923-e659-4993-8d5d-559f140ec59d")
public abstract class AbstractSplitBox
extends AbstractCompositeField
implements ISplitBox {
    private SplitBoxGrid m_grid;
    private ISplitBoxUIFacade m_uiFacade;
    private boolean m_cacheSplitterPosition;
    private String m_cacheSplitterPositionPropertyName;

    public AbstractSplitBox() {
        this(true);
    }

    public AbstractSplitBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected int getConfiguredGridW() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredSplitHorizontal() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    protected boolean getConfiguredSplitterEnabled() {
        return true;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=340.0)
    protected double getConfiguredSplitterPosition() {
        return 0.5;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=345.0)
    protected Double getConfiguredMinSplitterPosition() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=340.0)
    protected String getConfiguredSplitterPositionType() {
        return "relativeFirst";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=355.0)
    protected boolean getConfiguredCacheSplitterPosition() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=360.0)
    protected String getConfiguredCacheSplitterPositionPropertyName() {
        return this.getClass().getName();
    }

    @Override
    public String getPreferenceBaseKey() {
        return this.getConfiguredCacheSplitterPositionPropertyName();
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=370.0)
    protected Class<? extends IFormField> getConfiguredCollapsibleField() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=380.0)
    protected boolean getConfiguredFieldCollapsed() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=400.0)
    protected boolean getConfiguredFieldMinimized() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=400.0)
    protected boolean getConfiguredMinimizeEnabled() {
        return true;
    }

    @ConfigProperty(value="STRING")
    @Order(value=410.0)
    protected String getConfiguredToogleCollapseKeyStroke() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=420.0)
    protected String getConfiguredFirstCollapseKeyStroke() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=430.0)
    protected String getConfiguredSecondCollapseKeyStroke() {
        return null;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_grid = new SplitBoxGrid();
        super.initConfig();
        this.setSplitHorizontal(this.getConfiguredSplitHorizontal());
        this.setSplitterEnabled(this.getConfiguredSplitterEnabled());
        this.setCacheSplitterPosition(this.getConfiguredCacheSplitterPosition());
        this.setCacheSplitterPositionPropertyName(this.getConfiguredCacheSplitterPositionPropertyName());
        this.setMinSplitterPosition(this.getConfiguredMinSplitterPosition());
        this.setSplitterPositionType(this.getConfiguredSplitterPositionType());
        Double cachedSplitterPosition = ClientUIPreferences.getInstance().getSplitterPosition(this);
        if (this.isCacheSplitterPosition() && cachedSplitterPosition != null) {
            this.setSplitterPosition(cachedSplitterPosition);
        } else {
            this.setSplitterPosition(this.getConfiguredSplitterPosition());
        }
        if (this.getConfiguredCollapsibleField() != null) {
            this.setCollapsibleField(this.getFieldByClass(this.getConfiguredCollapsibleField()));
        }
        Boolean cachedFieldCollapsed = ClientUIPreferences.getInstance().getSplitBoxFieldCollapsed(this);
        if (this.isCacheSplitterPosition() && cachedFieldCollapsed != null) {
            this.setFieldCollapsed(cachedFieldCollapsed);
        } else {
            this.setFieldCollapsed(this.getConfiguredFieldCollapsed());
        }
        this.setToggleCollapseKeyStroke(this.getConfiguredToogleCollapseKeyStroke());
        this.setFirstCollapseKeyStroke(this.getConfiguredFirstCollapseKeyStroke());
        this.setSecondCollapseKeyStroke(this.getConfiguredSecondCollapseKeyStroke());
        Boolean cachedFieldMinimized = ClientUIPreferences.getInstance().getSplitBoxFieldMinimized(this);
        if (this.isCacheSplitterPosition() && cachedFieldMinimized != null) {
            this.setFieldMinimized(cachedFieldMinimized);
        } else {
            this.setFieldMinimized(this.getConfiguredFieldMinimized());
        }
        this.setMinimizeEnabled(this.getConfiguredMinimizeEnabled());
        this.getChildren().stream().filter(child -> child instanceof IGroupBox).map(child -> (IGroupBox)child).filter(groupBox -> groupBox.isResponsive().isUndefined()).forEach(groupBox -> groupBox.setResponsive(true));
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_grid.validate(this);
        if (this.isInitConfigDone() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    public SplitBoxGrid getFieldGrid() {
        return this.m_grid;
    }

    @Override
    protected void handleChildFieldVisibilityChanged() {
        super.handleChildFieldVisibilityChanged();
        if (this.isInitConfigDone()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public boolean isSplitHorizontal() {
        return this.propertySupport.getPropertyBool("splitHorizontal");
    }

    @Override
    public void setSplitHorizontal(boolean horizontal) {
        this.propertySupport.setPropertyBool("splitHorizontal", horizontal);
    }

    @Override
    public boolean isSplitterEnabled() {
        return this.propertySupport.getPropertyBool("splitterEnabled");
    }

    @Override
    public void setSplitterEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("splitterEnabled", enabled);
    }

    @Override
    public double getSplitterPosition() {
        return this.propertySupport.getPropertyDouble("splitterPosition");
    }

    @Override
    public void setSplitterPosition(double position) {
        this.propertySupport.setPropertyDouble("splitterPosition", position);
    }

    @Override
    public Double getMinSplitterPosition() {
        return (Double)this.propertySupport.getProperty("minSplitterPosition");
    }

    @Override
    public void setMinSplitterPosition(Double minPosition) {
        this.propertySupport.setProperty("minSplitterPosition", (Object)minPosition);
    }

    @Override
    public String getSplitterPositionType() {
        return this.propertySupport.getPropertyString("splitterPositionType");
    }

    @Override
    public void setSplitterPositionType(String splitterPositionType) {
        this.propertySupport.setPropertyString("splitterPositionType", splitterPositionType);
    }

    @Override
    public boolean isFieldMinimized() {
        return this.propertySupport.getPropertyBool("fieldMinimized");
    }

    @Override
    public void setFieldMinimized(boolean minimized) {
        this.propertySupport.setPropertyBool("fieldMinimized", minimized);
    }

    @Override
    public boolean isMinimizeEnabled() {
        return this.propertySupport.getPropertyBool("minimizeEnabled");
    }

    @Override
    public void setMinimizeEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("minimizeEnabled", enabled);
    }

    @Override
    public boolean isCacheSplitterPosition() {
        return this.m_cacheSplitterPosition;
    }

    @Override
    public void setCacheSplitterPosition(boolean b) {
        this.m_cacheSplitterPosition = b;
    }

    @Override
    public String getCacheSplitterPositionPropertyName() {
        return this.m_cacheSplitterPositionPropertyName;
    }

    @Override
    public void setCacheSplitterPositionPropertyName(String propName) {
        this.m_cacheSplitterPositionPropertyName = propName;
    }

    @Override
    public void setCollapsibleField(IFormField field) {
        this.propertySupport.setProperty("collapsibleField", (Object)field);
    }

    @Override
    public IFormField getCollapsibleField() {
        return (IFormField)this.propertySupport.getProperty("collapsibleField");
    }

    @Override
    public void setFieldCollapsed(boolean collapsed) {
        this.propertySupport.setProperty("fieldCollapsed", (Object)collapsed);
    }

    @Override
    public boolean isFieldCollapsed() {
        return this.propertySupport.getPropertyBool("fieldCollapsed");
    }

    @Override
    public void setToggleCollapseKeyStroke(String keyStroke) {
        this.propertySupport.setProperty("toggleCollapseKeyStroke", (Object)keyStroke);
    }

    @Override
    public String getToggleCollapseKeyStroke() {
        return this.propertySupport.getPropertyString("toggleCollapseKeyStroke");
    }

    @Override
    public void setFirstCollapseKeyStroke(String keyStroke) {
        this.propertySupport.setProperty("firstCollapseKeyStroke", (Object)keyStroke);
    }

    @Override
    public String getFirstCollapseKeyStroke() {
        return this.propertySupport.getPropertyString("firstCollapseKeyStroke");
    }

    @Override
    public void setSecondCollapseKeyStroke(String keyStroke) {
        this.propertySupport.setProperty("secondCollapseKeyStroke", (Object)keyStroke);
    }

    @Override
    public String getSecondCollapseKeyStroke() {
        return this.propertySupport.getPropertyString("secondCollapseKeyStroke");
    }

    @Override
    public ISplitBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected ISplitBoxExtension<? extends AbstractSplitBox> createLocalExtension() {
        return new LocalSplitBoxExtension<AbstractSplitBox>(this);
    }

    protected static class LocalSplitBoxExtension<OWNER extends AbstractSplitBox>
    extends AbstractCompositeField.LocalCompositeFieldExtension<OWNER>
    implements ISplitBoxExtension<OWNER> {
        public LocalSplitBoxExtension(OWNER owner) {
            super(owner);
        }
    }

    protected class P_UIFacade
    implements ISplitBoxUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setSplitterPositionFromUI(double splitterPosition) {
            AbstractSplitBox.this.setSplitterPosition(splitterPosition);
            ClientUIPreferences.getInstance().setAllSplitBoxPreferences(AbstractSplitBox.this);
        }

        @Override
        public void setMinSplitterPositionFromUI(Double minSplitterPosition) {
            AbstractSplitBox.this.setMinSplitterPosition(minSplitterPosition);
        }

        @Override
        public void setFieldCollapsedFromUI(boolean collapsed) {
            AbstractSplitBox.this.setFieldCollapsed(collapsed);
            ClientUIPreferences.getInstance().setAllSplitBoxPreferences(AbstractSplitBox.this);
        }

        @Override
        public void setFieldMinimizedFromUI(boolean minimized) {
            AbstractSplitBox.this.setFieldMinimized(minimized);
            ClientUIPreferences.getInstance().setAllSplitBoxPreferences(AbstractSplitBox.this);
        }

        @Override
        public void setMinimizeEnabledFromUI(boolean enabled) {
            AbstractSplitBox.this.setMinimizeEnabled(enabled);
        }
    }
}

