/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.services.lookup.IQueryParam;
import org.eclipse.scout.rt.client.services.lookup.LookupCallResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartFieldLookupRowFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRowFetchedCallback;

public class SmartFieldDataFetcher<LOOKUP_KEY>
extends AbstractSmartFieldLookupRowFetcher<LOOKUP_KEY> {
    public SmartFieldDataFetcher(ISmartField<LOOKUP_KEY> smartField) {
        super(smartField);
    }

    @Override
    public void update(IQueryParam<LOOKUP_KEY> queryParam, boolean synchronous) {
        block13: {
            int maxRowCount;
            int maxCount = this.getSmartField().getBrowseMaxRowCount();
            P_LookupCallDataCallback callback = new P_LookupCallDataCallback(queryParam);
            int n = maxRowCount = maxCount > 0 ? maxCount + 1 : 0;
            if (synchronous) {
                try {
                    if (queryParam.is(IQueryParam.QueryBy.KEY)) {
                        callback.onSuccess(this.getSmartField().callKeyLookup(queryParam.getKey()));
                        break block13;
                    }
                    if (queryParam.is(IQueryParam.QueryBy.ALL)) {
                        callback.onSuccess(this.getSmartField().callBrowseLookup(maxRowCount));
                        break block13;
                    }
                    if (queryParam.is(IQueryParam.QueryBy.TEXT)) {
                        callback.onSuccess(this.getSmartField().callTextLookup(queryParam.getText(), maxRowCount));
                        break block13;
                    }
                    throw new IllegalStateException();
                }
                catch (RuntimeException e) {
                    callback.onFailure(e);
                }
            } else if (queryParam.is(IQueryParam.QueryBy.KEY)) {
                this.getSmartField().callKeyLookupInBackground(queryParam.getKey(), callback);
            } else if (queryParam.is(IQueryParam.QueryBy.ALL)) {
                this.getSmartField().callBrowseLookupInBackground(maxRowCount, callback);
            } else if (queryParam.is(IQueryParam.QueryBy.TEXT)) {
                this.getSmartField().callTextLookupInBackground(queryParam.getText(), maxRowCount, callback);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private final class P_LookupCallDataCallback
    implements ILookupRowFetchedCallback<LOOKUP_KEY> {
        private final IQueryParam<LOOKUP_KEY> m_param;

        private P_LookupCallDataCallback(IQueryParam<LOOKUP_KEY> param) {
            this.m_param = param;
            SmartFieldDataFetcher.this.setResult(null);
        }

        public void onSuccess(List<? extends ILookupRow<LOOKUP_KEY>> rows) {
            SmartFieldDataFetcher.this.setResult(new LookupCallResult(new ArrayList(rows), this.m_param, null));
        }

        public void onFailure(RuntimeException exception) {
            SmartFieldDataFetcher.this.setResult(new LookupCallResult(null, this.m_param, exception));
        }
    }
}

