/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.lookup.IQueryParam;
import org.eclipse.scout.rt.client.services.lookup.LookupCallResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartFieldLookupRowFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.LookupJobHelper;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalSmartFieldDataFetcher<LOOKUP_KEY>
extends AbstractSmartFieldLookupRowFetcher<LOOKUP_KEY> {
    private static final Logger LOG = LoggerFactory.getLogger(HierarchicalSmartFieldDataFetcher.class);

    public HierarchicalSmartFieldDataFetcher(ISmartField<LOOKUP_KEY> smartField) {
        super(smartField);
    }

    @Override
    public void update(IQueryParam<LOOKUP_KEY> query, boolean blocking) {
        IFuture fRes = this.scheduleLookup(query).whenDoneSchedule(this.updateResult(query), this.newModelJobInput());
        if (blocking) {
            LookupJobHelper.awaitDone(fRes);
        }
    }

    private BiConsumer<List<ILookupRow<LOOKUP_KEY>>, Throwable> updateResult(IQueryParam<LOOKUP_KEY> query) {
        return (rows, error) -> {
            LookupCallResult result = new LookupCallResult(rows, query, (Throwable)error);
            if (error != null) {
                this.logException((Throwable)error);
            }
            this.setResult(result);
        };
    }

    protected void logException(Throwable e) {
        if (e instanceof VetoException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("", e);
            } else {
                LOG.info("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        } else if (e instanceof ProcessingException) {
            switch (((ProcessingException)e).getStatus().getSeverity()) {
                case 1: 
                case 256: {
                    LOG.info("", e);
                    break;
                }
                case 65536: {
                    LOG.warn("", e);
                    break;
                }
                default: {
                    LOG.error("", e);
                    break;
                }
            }
        } else {
            LOG.error("", e);
        }
    }

    private JobInput newModelJobInput() {
        return ModelJobs.newInput(ClientRunContexts.copyCurrent()).withExceptionHandling(null, false);
    }

    protected IFuture<List<ILookupRow<LOOKUP_KEY>>> scheduleLookup(IQueryParam<LOOKUP_KEY> query) {
        if (query.is(IQueryParam.QueryBy.REC)) {
            return this.getSmartField().callSubTreeLookupInBackground(query.getKey(), false);
        }
        if (query.is(IQueryParam.QueryBy.TEXT)) {
            return this.getSmartField().callTextLookupInBackground(query.getText(), true);
        }
        if (query.is(IQueryParam.QueryBy.ALL)) {
            return this.getSmartField().callBrowseLookupInBackground(true);
        }
        if (query.is(IQueryParam.QueryBy.KEY)) {
            return this.getSmartField().callKeyLookupInBackground(query.getKey(), true);
        }
        throw new IllegalStateException();
    }
}

