/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallResult;
import org.eclipse.scout.rt.client.services.lookup.IQueryParam;
import org.eclipse.scout.rt.client.services.lookup.LookupCallResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ILookupRowByKeyProvider;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.LookupJobHelper;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalLookupResultBuilder<VALUE> {
    private static final Logger LOG = LoggerFactory.getLogger(HierarchicalLookupResultBuilder.class);
    private final ISmartField<VALUE> m_smartField;
    private ILookupRowByKeyProvider<VALUE> m_lookupRowProvider;
    private final Map<VALUE, ILookupRow<VALUE>> m_keyCache = new HashMap<VALUE, ILookupRow<VALUE>>();

    public HierarchicalLookupResultBuilder(ISmartField<VALUE> smartField) {
        this.m_smartField = smartField;
    }

    protected List<ILookupRow<VALUE>> getRowsWithParents(List<ILookupRow<VALUE>> lookupRows, VALUE parent) {
        ArrayList<ILookupRow<VALUE>> res = new ArrayList<ILookupRow<VALUE>>();
        this.cacheKeys(lookupRows);
        HashSet<Object> allRows = new HashSet<Object>();
        List<List<ILookupRow<VALUE>>> paths = this.createPaths(lookupRows);
        if (parent == null) {
            for (List<ILookupRow<VALUE>> path : paths) {
                for (ILookupRow<VALUE> row : path) {
                    if (allRows.contains(row.getKey())) continue;
                    allRows.add(row.getKey());
                    res.add(row);
                }
            }
        } else {
            for (List<ILookupRow<VALUE>> path : paths) {
                ILookupRow<VALUE> leaf;
                if (!this.contains(parent, path) || allRows.contains((leaf = path.get(path.size() - 1)).getKey())) continue;
                allRows.add(leaf.getKey());
                res.add(leaf);
            }
        }
        return res;
    }

    protected boolean contains(VALUE key, List<ILookupRow<VALUE>> path) {
        if (key == null) {
            return false;
        }
        for (ILookupRow<VALUE> row : path) {
            if (!key.equals(row.getKey())) continue;
            return true;
        }
        return false;
    }

    protected ILookupRow<VALUE> getLookupRow(VALUE key) {
        if (key == null) {
            return null;
        }
        if (!this.m_keyCache.containsKey(key)) {
            ILookupRow<VALUE> row = this.m_lookupRowProvider.getLookupRow(key);
            this.m_keyCache.put(key, row);
            return row;
        }
        return this.m_keyCache.get(key);
    }

    protected List<List<ILookupRow<VALUE>>> createPaths(Collection<? extends ILookupRow<VALUE>> lookupRows) {
        Map<VALUE, ILookupRow<VALUE>> parentMap = this.createParentMap(lookupRows);
        ArrayList<List<ILookupRow<VALUE>>> paths = new ArrayList<List<ILookupRow<VALUE>>>();
        for (ILookupRow<VALUE> row : lookupRows) {
            ArrayList<ILookupRow<VALUE>> path = new ArrayList<ILookupRow<VALUE>>();
            ILookupRow<VALUE> r = row;
            while (r != null) {
                path.add(0, r);
                Object parentKey = r.getParentKey();
                if (parentKey == null) break;
                if (!parentMap.containsKey(r.getKey())) {
                    ILookupRow<Object> parentRow = this.getLookupRow(parentKey);
                    parentMap.put(r.getKey(), parentRow);
                }
                r = parentMap.get(r.getKey());
            }
            paths.add(path);
        }
        return paths;
    }

    protected void cacheKeys(Collection<? extends ILookupRow<VALUE>> lookupRows) {
        for (ILookupRow<VALUE> row : lookupRows) {
            this.m_keyCache.put(row.getKey(), row);
        }
    }

    protected Map<VALUE, ILookupRow<VALUE>> createParentMap(Collection<? extends ILookupRow<VALUE>> lookupRows) {
        for (ILookupRow<VALUE> row : lookupRows) {
            this.m_keyCache.put(row.getKey(), row);
        }
        HashMap<Object, ILookupRow<Object>> map = new HashMap<Object, ILookupRow<Object>>();
        for (ILookupRow<VALUE> row : lookupRows) {
            map.put(row.getKey(), this.getLookupRow(row.getParentKey()));
        }
        return map;
    }

    public ILookupCallResult<VALUE> addParentLookupRows(ILookupCallResult<VALUE> result) {
        List<Object> lookupRows;
        if (this.m_smartField.isLoadParentNodes()) {
            this.m_lookupRowProvider = this.m_smartField.isBrowseLoadIncremental() ? new P_KeyLookupRowProvider() : new P_BrowseLookupRowProvider();
            VALUE recKey = null;
            IQueryParam<VALUE> queryParam = result.getQueryParam();
            if (queryParam.is(IQueryParam.QueryBy.REC)) {
                recKey = queryParam.getKey();
            }
            lookupRows = this.getRowsWithParents(result.getLookupRows(), recKey);
        } else {
            lookupRows = result.getLookupRows();
        }
        return new LookupCallResult(lookupRows, result.getQueryParam(), result.getException());
    }

    private class P_BrowseLookupRowProvider
    implements ILookupRowByKeyProvider<VALUE> {
        private final FinalValue<Map<VALUE, ILookupRow<VALUE>>> m_rows = new FinalValue();

        private P_BrowseLookupRowProvider() {
        }

        @Override
        public ILookupRow<VALUE> getLookupRow(VALUE key) {
            this.m_rows.setIfAbsentAndGet(() -> {
                List rows = LookupJobHelper.await(HierarchicalLookupResultBuilder.this.m_smartField.callBrowseLookupInBackground(false));
                HashMap rowMap = new HashMap();
                for (ILookupRow r : rows) {
                    rowMap.put(r.getKey(), r);
                }
                return Collections.unmodifiableMap(rowMap);
            });
            return (ILookupRow)((Map)this.m_rows.get()).get(key);
        }
    }

    private class P_KeyLookupRowProvider
    implements ILookupRowByKeyProvider<VALUE> {
        private P_KeyLookupRowProvider() {
        }

        @Override
        public ILookupRow<VALUE> getLookupRow(VALUE key) {
            List rows = LookupJobHelper.await(HierarchicalLookupResultBuilder.this.m_smartField.callKeyLookupInBackground(key, false));
            if (rows.isEmpty()) {
                return null;
            }
            if (rows.size() > 1) {
                LOG.error("More than one row found for key {}", key);
                return null;
            }
            return rows.get(0);
        }
    }
}

