/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeFieldGrid;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;

public class SequenceBoxGrid
implements ICompositeFieldGrid<ISequenceBox> {
    private int m_gridColumns;
    private int m_gridRows;

    @Override
    public void validate(ISequenceBox sequenceBox) {
        this.setGridColumns(0);
        this.setGridRows(0);
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        for (IFormField f : sequenceBox.getFields()) {
            if (f.isVisible()) {
                list.add(f);
                continue;
            }
            GridData data = GridDataBuilder.createFromHints(f, 1);
            f.setGridDataInternal(data);
        }
        this.layoutStatic(list);
    }

    protected void layoutStatic(List<IFormField> fields) {
        int x = 0;
        for (IFormField field : fields) {
            GridData data = GridDataBuilder.createFromHints(field, 1);
            data.x = x;
            data.y = 0;
            if (data.weightX < 0.0) {
                this.updateWeightX(field, data);
            }
            field.setGridDataInternal(data);
            x += data.w;
            this.setGridRows(Math.max(this.m_gridRows, data.h));
        }
        this.setGridColumns(x);
    }

    protected void updateWeightX(IFormField field, GridData data) {
        if (field instanceof IButton) {
            this.updateButtonWeightX(data);
        } else {
            data.weightX = data.w;
        }
    }

    protected void updateButtonWeightX(GridData data) {
        data.useUiWidth = true;
        data.weightX = 0.0;
    }

    @Override
    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    protected void setGridColumns(int gridColumns) {
        this.m_gridColumns = gridColumns;
    }

    @Override
    public int getGridRowCount() {
        return this.m_gridRows;
    }

    protected void setGridRows(int gridRows) {
        this.m_gridRows = gridRows;
    }
}

