/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox;

import java.util.Arrays;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.InvalidSequenceStatus;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ApplicationScoped
public class SequenceValidationHelper {
    public <T extends Comparable<T>> void checkFromTo(IValueField<T> startField, IValueField<T> endField) {
        if (startField.getValue() == null || endField.getValue() == null) {
            this.clearInvalidSequenceStatus(startField, endField);
            return;
        }
        if (ObjectUtility.notEquals(((Comparable)startField.getValue()).getClass(), ((Comparable)endField.getValue()).getClass())) {
            this.clearInvalidSequenceStatus(startField, endField);
            return;
        }
        if (ObjectUtility.compareTo((Comparable)((Comparable)startField.getValue()), (Comparable)((Comparable)endField.getValue())) > 0) {
            IValueField<T> errorField = startField;
            if (endField.isValueChanging() && !StringUtility.isNullOrEmpty((CharSequence)endField.getLabel())) {
                errorField = endField;
            }
            InvalidSequenceStatus errorStatus = new InvalidSequenceStatus(TEXTS.get((String)"XMustBeGreaterThanOrEqualY", (String[])new String[]{startField.getLabel(), endField.getLabel()}));
            errorField.addErrorStatus((IStatus)errorStatus);
            return;
        }
        this.clearInvalidSequenceStatus(startField, endField);
    }

    protected void clearInvalidSequenceStatus(IValueField<?> ... fields) {
        Arrays.stream(fields).forEach(f -> f.removeErrorStatus(InvalidSequenceStatus.class));
    }
}

