/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox;

import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.InvalidSequenceStatus;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@ClassId(value="4a0d8a5e-45d5-4ba3-a2d8-f456bb92132c")
public abstract class AbstractFromToSequenceBox
extends AbstractSequenceBox {
    protected AbstractFromToSequenceBox() {
        this(true);
    }

    protected AbstractFromToSequenceBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected <T extends Comparable<T>> void execCheckFromTo(IValueField<T>[] valueFields, int changedIndex) {
        Comparable o2;
        if (valueFields == null || valueFields.length != 2 || valueFields[0] == null || valueFields[1] == null || valueFields[0].getValue() == null || valueFields[1].getValue() == null) {
            this.clearErrorStatus();
            return;
        }
        Comparable o1 = (Comparable)valueFields[0].getValue();
        if (ObjectUtility.compareTo((Comparable)o1, (Comparable)(o2 = (Comparable)valueFields[1].getValue())) > 0) {
            InvalidSequenceStatus errorStatus = new InvalidSequenceStatus(TEXTS.get((String)"XMustBeGreaterThanOrEqualY", (String[])new String[]{TEXTS.get((String)"to"), TEXTS.get((String)"from")}));
            this.addErrorStatus((IStatus)errorStatus);
            return;
        }
        this.clearErrorStatus();
    }

    @Override
    protected void execAddSearchTerms(SearchFilter search) {
        if (this.getFields().size() < 2) {
            return;
        }
        IValueField field1 = (IValueField)this.getFields().get(0);
        Object value1 = field1.getValue();
        IValueField field2 = (IValueField)this.getFields().get(1);
        Object value2 = field2.getValue();
        if (value1 != null && value2 != null) {
            search.addDisplayText(this.getLabel() + " " + TEXTS.get((String)"from") + " " + field1.getDisplayText() + " " + TEXTS.get((String)"to") + " " + field2.getDisplayText());
        } else if (value1 != null) {
            search.addDisplayText(this.getLabel() + " " + TEXTS.get((String)"from") + " " + field1.getDisplayText());
        } else if (value2 != null) {
            search.addDisplayText(this.getLabel() + " " + TEXTS.get((String)"to") + " " + field2.getDisplayText());
        }
    }

    @Override
    protected boolean execIsLabelSuffixCandidate(IFormField formField) {
        if (this.getFieldIndex(formField) > 0) {
            return false;
        }
        return super.execIsLabelSuffixCandidate(formField);
    }
}

