/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.pagefield;

import java.util.List;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.pagefield.IPageFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.pagefield.PageFieldChains;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.controls.SearchFormTableControl;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.pagefield.IPageField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.AbstractWrappedFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;

@ClassId(value="e2f4e714-637f-4a9b-b3be-d672900e1374")
public abstract class AbstractPageField<PAGE extends IPage>
extends AbstractGroupBox
implements IPageField<PAGE> {
    private PAGE m_page;
    private SimpleOutline m_outline;

    public AbstractPageField() {
        this(true);
    }

    public AbstractPageField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return false;
    }

    @Override
    protected void initConfig() {
        this.m_outline = new SimpleOutline();
        super.initConfig();
    }

    @Override
    protected void disposeFieldInternal() {
        if (this.m_outline != null) {
            this.m_outline.dispose();
        }
        super.disposeFieldInternal();
    }

    @Override
    public final PAGE getPage() {
        return this.m_page;
    }

    @Override
    public void setPage(PAGE newPage) {
        this.setPageInternal(newPage);
    }

    private void setPageInternal(PAGE page) {
        if (this.m_page == page) {
            return;
        }
        this.getDetailFormField().setInnerForm(null);
        this.getTableField().setTable(null, true);
        this.getSearchFormField().setInnerForm(null);
        if (this.m_outline != null) {
            this.m_outline.dispose();
            this.m_outline = null;
            this.m_page = null;
        }
        PAGE oldPage = this.m_page;
        this.m_page = page;
        if (this.m_page != null) {
            this.m_outline = new SimpleOutline();
            this.m_outline.setRootNode((ITreeNode)this.m_page);
            this.m_outline.selectNode((ITreeNode)this.m_page);
            this.m_outline.addPropertyChangeListener(e -> {
                try {
                    if (e.getPropertyName().equals("detailForm")) {
                        this.getDetailFormField().setInnerForm(((IOutline)e.getSource()).getDetailForm());
                    } else if (e.getPropertyName().equals("detailTable")) {
                        this.getTableField().setTable(this.detachSearchFormTableControl(((IOutline)e.getSource()).getDetailTable()), true);
                    } else if (e.getPropertyName().equals("searchForm")) {
                        this.getSearchFormField().setInnerForm(((IOutline)e.getSource()).getSearchForm());
                    }
                }
                catch (RuntimeException | PlatformError ex) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
                }
            });
            this.getDetailFormField().setInnerForm(this.m_outline.getDetailForm());
            this.getTableField().setTable(this.detachSearchFormTableControl(this.m_outline.getDetailTable()), true);
            this.getSearchFormField().setInnerForm(this.m_outline.getSearchForm());
        }
        this.interceptPageChanged(oldPage, this.m_page);
    }

    protected ITable detachSearchFormTableControl(ITable table) {
        SearchFormTableControl searchControl = table.getTableControl(SearchFormTableControl.class);
        if (searchControl != null) {
            table.removeTableControl(searchControl);
        }
        return table;
    }

    @Override
    public IWrappedFormField<IForm> getDetailFormField() {
        return this.getFieldByClass(DetailFormField.class);
    }

    @Override
    public ITableField<ITable> getTableField() {
        return this.getFieldByClass(TableField.class);
    }

    @Override
    public IWrappedFormField<IForm> getSearchFormField() {
        return this.getFieldByClass(SearchFormField.class);
    }

    @ConfigOperation
    protected void execPageChanged(PAGE oldPage, PAGE newPage) {
    }

    protected final void interceptPageChanged(PAGE oldPage, PAGE newPage) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        PageFieldChains.PageFieldPageChangedChain<PAGE> chain = new PageFieldChains.PageFieldPageChangedChain<PAGE>(extensions);
        chain.execPageChanged(oldPage, newPage);
    }

    @Override
    protected IPageFieldExtension<PAGE, ? extends AbstractPageField<PAGE>> createLocalExtension() {
        return new LocalPageFieldExtension(this);
    }

    @Order(value=30.0)
    @ClassId(value="8808ad60-c941-4086-b470-72f23dd8125e")
    public class DetailFormField
    extends AbstractWrappedFormField<IForm> {
        @Override
        protected int getConfiguredGridW() {
            return 0;
        }

        @Override
        protected boolean execCalculateVisible() {
            return this.getInnerForm() != null;
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.addPropertyChangeListener("innerForm", evt -> this.calculateVisibleInternal());
        }
    }

    protected static class LocalPageFieldExtension<T extends IPage, OWNER extends AbstractPageField<T>>
    extends AbstractGroupBox.LocalGroupBoxExtension<OWNER>
    implements IPageFieldExtension<T, OWNER> {
        public LocalPageFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execPageChanged(PageFieldChains.PageFieldPageChangedChain<T> chain, T oldPage, T newPage) {
            ((AbstractPageField)this.getOwner()).execPageChanged(oldPage, newPage);
        }
    }

    @Order(value=10.0)
    @ClassId(value="5eb7b330-3549-4bdf-a4e9-cc4486e44f36")
    public class SearchFormField
    extends AbstractWrappedFormField<IForm> {
        @Override
        protected int getConfiguredGridW() {
            return 0;
        }

        @Override
        protected int getConfiguredGridH() {
            return 2;
        }

        @Override
        protected double getConfiguredGridWeightY() {
            return 0.0;
        }

        @Override
        protected boolean execCalculateVisible() {
            return this.getInnerForm() != null;
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.addPropertyChangeListener("innerForm", evt -> this.calculateVisibleInternal());
        }
    }

    @Order(value=10.0)
    @ClassId(value="6be65846-72ec-49ec-aad2-42caa75709d3")
    public static class SimpleOutline
    extends AbstractOutline {
        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return true;
        }

        @Override
        public ClientRunContext createDisplayParentRunContext() {
            return ClientRunContexts.copyCurrent();
        }
    }

    @Order(value=20.0)
    @ClassId(value="5bff61f0-9f9a-492c-ba33-cdc1407eeade")
    public class TableField
    extends AbstractTableField<ITable> {
        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected int getConfiguredGridW() {
            return 0;
        }

        @Override
        protected int getConfiguredGridH() {
            return 7;
        }

        @Override
        protected double getConfiguredGridWeightY() {
            return 1.0;
        }

        @Override
        protected boolean execCalculateVisible() {
            return this.getTable() != null;
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.addPropertyChangeListener("table", evt -> this.calculateVisibleInternal());
        }
    }
}

