/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.longfield;

import java.math.BigDecimal;
import org.eclipse.scout.rt.client.extension.ui.form.fields.longfield.ILongFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="cfc961a1-195f-491d-94c5-762f9d86efee")
public abstract class AbstractLongField
extends AbstractNumberField<Long>
implements ILongField {
    public AbstractLongField() {
        this(true);
    }

    public AbstractLongField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigProperty(value="LONG")
    @Order(value=250.0)
    protected Long getConfiguredMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    @ConfigProperty(value="LONG")
    @Order(value=260.0)
    protected Long getConfiguredMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    @Order(value=270.0)
    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxIntegerDigits() {
        return 19;
    }

    @Override
    protected Long getMinPossibleValue() {
        return Long.MIN_VALUE;
    }

    @Override
    protected Long getMaxPossibleValue() {
        return Long.MAX_VALUE;
    }

    @Override
    protected Long parseValueInternal(String text) {
        Long retVal = null;
        BigDecimal parsedVal = this.parseToBigDecimalInternal(text);
        if (parsedVal != null) {
            retVal = parsedVal.longValueExact();
        }
        return retVal;
    }

    @Override
    protected ILongFieldExtension<? extends AbstractLongField> createLocalExtension() {
        return new LocalLongFieldExtension<AbstractLongField>(this);
    }

    protected static class LocalLongFieldExtension<OWNER extends AbstractLongField>
    extends AbstractNumberField.LocalNumberFieldExtension<Long, OWNER>
    implements ILongFieldExtension<OWNER> {
        public LocalLongFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

