/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.integerfield;

import java.math.BigDecimal;
import org.eclipse.scout.rt.client.extension.ui.form.fields.integerfield.IIntegerFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="4418100d-db7c-40e7-84b4-29df65534671")
public abstract class AbstractIntegerField
extends AbstractNumberField<Integer>
implements IIntegerField {
    public AbstractIntegerField() {
        this(true);
    }

    public AbstractIntegerField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigProperty(value="INTEGER")
    @Order(value=250.0)
    protected Integer getConfiguredMinValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    @ConfigProperty(value="INTEGER")
    @Order(value=260.0)
    protected Integer getConfiguredMaxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Order(value=270.0)
    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxIntegerDigits() {
        return 10;
    }

    @Override
    protected Integer getMinPossibleValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    protected Integer getMaxPossibleValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected Integer parseValueInternal(String text) {
        Integer retVal = null;
        BigDecimal parsedVal = this.parseToBigDecimalInternal(text);
        if (parsedVal != null) {
            retVal = parsedVal.intValueExact();
        }
        return retVal;
    }

    @Override
    protected IIntegerFieldExtension<? extends AbstractIntegerField> createLocalExtension() {
        return new LocalIntegerFieldExtension<AbstractIntegerField>(this);
    }

    protected static class LocalIntegerFieldExtension<OWNER extends AbstractIntegerField>
    extends AbstractNumberField.LocalNumberFieldExtension<Integer, OWNER>
    implements IIntegerFieldExtension<OWNER> {
        public LocalIntegerFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

