/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.imagefield;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.imagebox.IImageFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.imagebox.ImageFieldChains;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IFormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.ImageFieldContextMenu;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.imagefield.IImageField;
import org.eclipse.scout.rt.client.ui.form.fields.imagefield.IImageFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.imagefield.ImageFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.imagefield.ImageFieldListener;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.data.basic.AffineTransformSpec;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;

@ClassId(value="480ea07e-9cec-4591-ba73-4bb9aa45a60d")
public abstract class AbstractImageField
extends AbstractFormField
implements IImageField {
    private IImageFieldUIFacade m_uiFacade;
    private final FastListenerList<ImageFieldListener> m_listenerList = new FastListenerList();
    private double m_zoomDelta;
    private double m_panDelta;
    private double m_rotateDelta;

    public AbstractImageField() {
        this(true);
    }

    public AbstractImageField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected int getConfiguredVerticalAlignment() {
        return 0;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=300.0)
    protected String getConfiguredImageId() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=310.0)
    protected String getConfiguredImageUrl() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    protected boolean getConfiguredAutoFit() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=330.0)
    protected double getConfiguredZoomDelta() {
        return 1.25;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=340.0)
    protected double getConfiguredPanDelta() {
        return 10.0;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=350.0)
    protected double getConfiguredRotateDelta() {
        return 10.0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=360.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=370.0)
    protected boolean getConfiguredUploadEnabled() {
        return false;
    }

    @ConfigProperty(value="FILE_EXTENSIONS")
    @Order(value=380.0)
    protected List<String> getConfiguredFileExtensions() {
        return CollectionUtility.arrayList((Object[])new String[]{"png", "bmp", "jpg", "jpeg", "gif"});
    }

    @ConfigProperty(value="LONG")
    @Order(value=190.0)
    protected long getConfiguredDropMaximumSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=400.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=410.0)
    protected final int getConfiguredDragType() {
        return 0;
    }

    @ConfigOperation
    @Order(value=500.0)
    protected final TransferObject execDragRequest() {
        return null;
    }

    @ConfigOperation
    @Order(value=510.0)
    protected void execDropRequest(TransferObject transferObject) {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setImageTransform(new AffineTransformSpec());
        this.setAutoFit(this.getConfiguredAutoFit());
        this.setImageId(this.getConfiguredImageId());
        this.setImageUrl(this.getConfiguredImageUrl());
        this.setPanDelta(this.getConfiguredPanDelta());
        this.setRotateDelta(this.getConfiguredRotateDelta());
        this.setZoomDelta(this.getConfiguredZoomDelta());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setDropMaximumSize(this.getConfiguredDropMaximumSize());
        this.setScrollBarEnabled(this.getConfiguredScrollBarEnabled());
        this.setUploadEnabled(this.getConfiguredUploadEnabled());
        this.setFileExtensions(this.getConfiguredFileExtensions());
    }

    @Override
    protected IFormFieldContextMenu createContextMenu(OrderedCollection<IMenu> menus) {
        return new ImageFieldContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
    }

    @Override
    public IFastListenerList<ImageFieldListener> imageFieldListeners() {
        return this.m_listenerList;
    }

    private void fireZoomRectangle(BoundsSpec r) {
        this.fireImageBoxEventInternal(new ImageFieldEvent(this, 10, r));
    }

    private void fireAutoFit() {
        this.fireImageBoxEventInternal(new ImageFieldEvent(this, 20));
    }

    private void fireImageBoxEventInternal(ImageFieldEvent e) {
        this.imageFieldListeners().list().forEach(listener -> listener.imageFieldChanged(e));
    }

    @Override
    public String getImageUrl() {
        return this.propertySupport.getPropertyString("imageUrl");
    }

    @Override
    public void setImageUrl(String imageUrl) {
        this.propertySupport.setProperty("imageUrl", (Object)imageUrl);
    }

    @Override
    public Object getImage() {
        return this.propertySupport.getProperty("image");
    }

    @Override
    public void setImage(Object imgObj) {
        this.propertySupport.setProperty("image", imgObj);
    }

    @Override
    public String getImageId() {
        return this.propertySupport.getPropertyString("imageId");
    }

    @Override
    public void setImageId(String imageId) {
        this.propertySupport.setPropertyString("imageId", imageId);
    }

    @Override
    public double getZoomDeltaValue() {
        return this.m_zoomDelta;
    }

    @Override
    public void setZoomDelta(double d) {
        this.m_zoomDelta = d;
    }

    @Override
    public double getPanDelta() {
        return this.m_panDelta;
    }

    @Override
    public void setPanDelta(double d) {
        this.m_panDelta = d;
    }

    @Override
    public double getRotateDelta() {
        return this.m_rotateDelta;
    }

    @Override
    public void setRotateDelta(double deg) {
        this.m_rotateDelta = deg;
    }

    @Override
    public void setRotateDeltaInRadians(double rad) {
        this.setRotateDelta(Math.toDegrees(rad));
    }

    @Override
    public AffineTransformSpec getImageTransform() {
        return new AffineTransformSpec((AffineTransformSpec)this.propertySupport.getProperty("imageTransform"));
    }

    @Override
    public void setImageTransform(AffineTransformSpec t) {
        this.propertySupport.setProperty("imageTransform", (Object)new AffineTransformSpec(t));
    }

    @Override
    public BoundsSpec getAnalysisRectangle() {
        return (BoundsSpec)this.propertySupport.getProperty("analysisRectangle");
    }

    @Override
    public void setAnalysisRectangle(BoundsSpec rect) {
        this.propertySupport.setProperty("analysisRectangle", (Object)rect);
    }

    @Override
    public void setAnalysisRectangle(int x, int y, int w, int h) {
        this.setAnalysisRectangle(new BoundsSpec(x, y, w, h));
    }

    @Override
    public boolean isAutoFit() {
        return this.propertySupport.getPropertyBool("autoFit");
    }

    @Override
    public void setAutoFit(boolean b) {
        this.propertySupport.setPropertyBool("autoFit", b);
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.propertySupport.getPropertyBool("scrollBarEnabled");
    }

    @Override
    public void setScrollBarEnabled(boolean b) {
        this.propertySupport.setPropertyBool("scrollBarEnabled", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.propertySupport.setPropertyLong("dropMaximumSize", dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.propertySupport.getPropertyInt("dropMaximumSize");
    }

    @Override
    public byte[] getByteArrayValue() {
        Object value = this.getImage();
        byte[] b = null;
        if (value instanceof byte[]) {
            b = (byte[])value;
        }
        return b;
    }

    @Override
    public void doAutoFit() {
        this.fireAutoFit();
    }

    @Override
    public void doZoomRectangle(int x, int y, int w, int h) {
        this.fireZoomRectangle(new BoundsSpec(x, y, w, h));
    }

    @Override
    public void doPan(double dx, double dy) {
        AffineTransformSpec t = this.getImageTransform();
        t.dx = dx;
        t.dy = dy;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativePan(double dx, double dy) {
        AffineTransformSpec t = this.getImageTransform();
        t.dx += dx;
        t.dy += dy;
        this.setImageTransform(t);
    }

    @Override
    public void doZoom(double fx, double fy) {
        AffineTransformSpec t = this.getImageTransform();
        t.sx = fx;
        t.sy = fy;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativeZoom(double fx, double fy) {
        AffineTransformSpec t = this.getImageTransform();
        t.sx *= fx;
        t.sy *= fy;
        this.setImageTransform(t);
    }

    @Override
    public void doRotate(double angle) {
        AffineTransformSpec t = this.getImageTransform();
        t.angle = angle;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativeRotate(double angleInDegrees) {
        AffineTransformSpec t = this.getImageTransform();
        t.angle += Math.toRadians(angleInDegrees);
        this.setImageTransform(t);
    }

    @Override
    public boolean isUploadEnabled() {
        return this.propertySupport.getPropertyBool("uploadEnabled");
    }

    @Override
    public void setUploadEnabled(boolean uploadEnabled) {
        this.propertySupport.setPropertyBool("uploadEnabled", uploadEnabled);
    }

    @Override
    public void setFileExtensions(List<String> fileExtensions) {
        this.setProperty("fileExtensions", CollectionUtility.arrayListWithoutNullElements(fileExtensions));
    }

    @Override
    public List<String> getFileExtensions() {
        return CollectionUtility.arrayList((Collection)((List)this.getProperty("fileExtensions")));
    }

    @Override
    public IImageFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected final TransferObject interceptDragRequest() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ImageFieldChains.ImageFieldDragRequestChain chain = new ImageFieldChains.ImageFieldDragRequestChain(extensions);
        return chain.execDragRequest();
    }

    protected final void interceptDropRequest(TransferObject transferObject) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ImageFieldChains.ImageFieldDropRequestChain chain = new ImageFieldChains.ImageFieldDropRequestChain(extensions);
        chain.execDropRequest(transferObject);
    }

    protected IImageFieldExtension<? extends AbstractImageField> createLocalExtension() {
        return new LocalImageFieldExtension<AbstractImageField>(this);
    }

    protected static class LocalImageFieldExtension<OWNER extends AbstractImageField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IImageFieldExtension<OWNER> {
        public LocalImageFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public TransferObject execDragRequest(ImageFieldChains.ImageFieldDragRequestChain chain) {
            return ((AbstractImageField)this.getOwner()).execDragRequest();
        }

        @Override
        public void execDropRequest(ImageFieldChains.ImageFieldDropRequestChain chain, TransferObject transferObject) {
            ((AbstractImageField)this.getOwner()).execDropRequest(transferObject);
        }
    }

    protected class P_UIFacade
    implements IImageFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void setImageTransformFromUI(AffineTransformSpec t) {
            if (!AbstractImageField.this.isEnabledIncludingParents() || !AbstractImageField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractImageField.this.setImageTransform(t);
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            TransferObject t = null;
            t = AbstractImageField.this.interceptDragRequest();
            return t;
        }

        @Override
        public void fireDropActionFromUi(TransferObject scoutTransferable) {
            if (!AbstractImageField.this.isEnabledIncludingParents() || !AbstractImageField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractImageField.this.interceptDropRequest(scoutTransferable);
        }
    }
}

