/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.htmlfield;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.htmlfield.HtmlFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.htmlfield.IHtmlFieldExtension;
import org.eclipse.scout.rt.client.res.AttachmentSupport;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.IOUtility;

@ClassId(value="99301bfb-cccc-431f-b687-dc0bf73ff789")
public abstract class AbstractHtmlField
extends AbstractValueField<String>
implements IHtmlField {
    private IHtmlFieldUIFacade m_uiFacade;
    private AttachmentSupport m_attachmentSupport = (AttachmentSupport)BEANS.get(AttachmentSupport.class);

    public AbstractHtmlField() {
        this(true);
    }

    public AbstractHtmlField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredSelectable() {
        return true;
    }

    @Override
    protected boolean getConfiguredPreventInitialFocus() {
        return true;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execAppLinkAction(String ref) {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setSelectable(this.getConfiguredSelectable());
        this.setScrollBarEnabled(this.getConfiguredScrollBarEnabled());
        this.setHtmlEnabled(true);
    }

    @Override
    public void doAppLinkAction(String ref) {
        this.interceptAppLinkAction(ref);
    }

    public void setValueFromURL(URL url, String encoding) {
        block12: {
            if (url != null) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStreamReader in = new InputStreamReader(url.openStream(), encoding);){
                        this.setValue(IOUtility.readString((Reader)in));
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new ProcessingException("URL " + String.valueOf(url), new Object[]{e});
                }
            }
            this.setValue(null);
        }
    }

    @Override
    public String getPlainText() {
        String s = (String)this.getValue();
        if (s == null) {
            return "";
        }
        return ((HtmlHelper)BEANS.get(HtmlHelper.class)).toPlainText(s);
    }

    @Override
    protected String validateValueInternal(String rawValue) {
        String validValue = null;
        validValue = rawValue = super.validateValueInternal(rawValue);
        if (validValue != null && validValue.isEmpty()) {
            validValue = null;
        }
        return validValue;
    }

    @Override
    public IHtmlFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String parseValueInternal(String text) {
        if (text != null && text.isEmpty()) {
            text = null;
        }
        return text;
    }

    @Override
    public Set<BinaryResource> getAttachments() {
        return this.m_attachmentSupport.getAttachments();
    }

    @Override
    public BinaryResource getAttachment(String filename) {
        return this.m_attachmentSupport.getAttachment(filename);
    }

    @Override
    public void setAttachments(Collection<? extends BinaryResource> attachments) {
        this.m_attachmentSupport.setAttachments(attachments);
    }

    @Override
    public void addAttachment(BinaryResource attachment) {
        this.m_attachmentSupport.addAttachment(attachment);
    }

    @Override
    public void removeAttachment(BinaryResource attachment) {
        this.m_attachmentSupport.removeAttachment(attachment);
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.propertySupport.setPropertyBool("selectable", selectable);
    }

    @Override
    public boolean isSelectable() {
        return this.propertySupport.getPropertyBool("selectable");
    }

    @Override
    public void setScrollBarEnabled(boolean scrollBarEnabled) {
        this.propertySupport.setPropertyBool("scrollBarEnabled", scrollBarEnabled);
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.propertySupport.getPropertyBool("scrollBarEnabled");
    }

    @Override
    public void setScrollToAnchor(String anchorName) {
        this.propertySupport.setPropertyString("scrollToAnchor", anchorName);
    }

    @Override
    public String getScrollToAnchor() {
        return this.propertySupport.getPropertyString("scrollToAnchor");
    }

    @Override
    public void scrollToEnd() {
        this.propertySupport.setPropertyAlwaysFire("scrollToEnd", null);
    }

    @Override
    public void setHtmlEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("htmlEnabled", enabled);
    }

    @Override
    public boolean isHtmlEnabled() {
        return this.propertySupport.getPropertyBool("htmlEnabled");
    }

    protected final void interceptAppLinkAction(String ref) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        HtmlFieldChains.HtmlFieldAppLinkActionChain chain = new HtmlFieldChains.HtmlFieldAppLinkActionChain(extensions);
        chain.execAppLinkAction(ref);
    }

    @Override
    protected IHtmlFieldExtension<? extends AbstractHtmlField> createLocalExtension() {
        return new LocalHtmlFieldExtension<AbstractHtmlField>(this);
    }

    protected static class LocalHtmlFieldExtension<OWNER extends AbstractHtmlField>
    extends AbstractValueField.LocalValueFieldExtension<String, OWNER>
    implements IHtmlFieldExtension<OWNER> {
        public LocalHtmlFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execAppLinkAction(HtmlFieldChains.HtmlFieldAppLinkActionChain chain, String ref) {
            ((AbstractHtmlField)this.getOwner()).execAppLinkAction(ref);
        }
    }

    protected class P_UIFacade
    implements IHtmlFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            AbstractHtmlField.this.doAppLinkAction(ref);
        }
    }
}

