/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.filechooserfield;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.filechooserfield.IFileChooserFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ClassId(value="8d2818c2-5659-4c03-87ef-09441302fbdd")
public abstract class AbstractFileChooserField
extends AbstractValueField<BinaryResource>
implements IFileChooserField {
    private IFileChooserFieldUIFacade m_uiFacade;
    private boolean m_showFileExtension;

    public AbstractFileChooserField() {
        this(true);
    }

    public AbstractFileChooserField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredShowFileExtension() {
        return true;
    }

    @ConfigProperty(value="FILE_EXTENSIONS")
    @Order(value=230.0)
    protected List<String> getConfiguredFileExtensions() {
        return null;
    }

    @ConfigProperty(value="LONG")
    @Order(value=310.0)
    protected long getConfiguredMaximumUploadSize() {
        return 0x3200000L;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setShowFileExtension(this.getConfiguredShowFileExtension());
        this.setFileExtensions(this.getConfiguredFileExtensions());
        this.setMaximumUploadSize(this.getConfiguredMaximumUploadSize());
    }

    @Override
    public IFileChooserFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setShowFileExtension(boolean b) {
        this.m_showFileExtension = b;
        this.refreshDisplayText();
    }

    @Override
    public boolean isShowFileExtension() {
        return this.m_showFileExtension;
    }

    @Override
    public void setFileExtensions(List<String> fileExtensions) {
        this.setProperty("fileExtensions", CollectionUtility.arrayListWithoutNullElements(fileExtensions));
    }

    @Override
    public List<String> getFileExtensions() {
        return CollectionUtility.arrayList((Collection)((List)this.getProperty("fileExtensions")));
    }

    @Override
    public void setMaximumUploadSize(long maximumUploadSize) {
        this.propertySupport.setPropertyLong("maximumUploadSize", maximumUploadSize);
    }

    @Override
    public long getMaximumUploadSize() {
        return this.propertySupport.getPropertyLong("maximumUploadSize");
    }

    @Override
    public String getFileName() {
        BinaryResource value = (BinaryResource)this.getValue();
        if (value != null) {
            return value.getFilename();
        }
        return null;
    }

    @Override
    public int getFileSize() {
        BinaryResource value = (BinaryResource)this.getValue();
        if (value != null) {
            return value.getContentLength();
        }
        return 0;
    }

    @Override
    protected String formatValueInternal(BinaryResource validValue) {
        if (validValue == null) {
            return null;
        }
        String filename = validValue.getFilename();
        if (StringUtility.hasText((CharSequence)filename)) {
            if (!this.isShowFileExtension() && filename.indexOf(46) >= 0) {
                return filename.substring(0, filename.lastIndexOf(46));
            }
            return filename;
        }
        return null;
    }

    @Override
    protected BinaryResource parseValueInternal(String text) {
        if (StringUtility.hasText((CharSequence)text)) {
            return (BinaryResource)this.getValue();
        }
        return null;
    }

    @Override
    protected IFileChooserFieldExtension<? extends AbstractFileChooserField> createLocalExtension() {
        return new LocalFileChooserFieldExtension<AbstractFileChooserField>(this);
    }

    protected static class LocalFileChooserFieldExtension<OWNER extends AbstractFileChooserField>
    extends AbstractValueField.LocalValueFieldExtension<BinaryResource, OWNER>
    implements IFileChooserFieldExtension<OWNER> {
        public LocalFileChooserFieldExtension(OWNER owner) {
            super(owner);
        }
    }

    protected class P_UIFacade
    implements IFileChooserFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void parseAndSetValueFromUI(String value) {
            if (!AbstractFileChooserField.this.isEnabledIncludingParents() || !AbstractFileChooserField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractFileChooserField.this.parseAndSetValue(value);
        }
    }
}

