/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.filechooserbutton;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.filechooserbutton.IFileChooserButtonExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserbutton.IFileChooserButton;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="20038f90-75fa-4796-8a08-a9417ae69c60")
public abstract class AbstractFileChooserButton
extends AbstractValueField<BinaryResource>
implements IFileChooserButton {
    public AbstractFileChooserButton() {
        this(true);
    }

    public AbstractFileChooserButton(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredShowFileExtension() {
        return true;
    }

    @ConfigProperty(value="FILE_EXTENSIONS")
    @Order(value=200.0)
    protected List<String> getConfiguredFileExtensions() {
        return null;
    }

    @ConfigProperty(value="LONG")
    @Order(value=300.0)
    protected long getConfiguredMaximumUploadSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="STRING")
    @Order(value=400.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredFillHorizontal() {
        return false;
    }

    @Override
    protected boolean getConfiguredStatusVisible() {
        return false;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setFileExtensions(this.getConfiguredFileExtensions());
        this.setMaximumUploadSize(this.getConfiguredMaximumUploadSize());
        this.setIconId(this.getConfiguredIconId());
    }

    @Override
    public void setFileExtensions(List<String> fileExtensions) {
        this.setProperty("fileExtensions", CollectionUtility.arrayListWithoutNullElements(fileExtensions));
    }

    @Override
    public List<String> getFileExtensions() {
        return CollectionUtility.arrayList((Collection)((List)this.getProperty("fileExtensions")));
    }

    @Override
    public void setMaximumUploadSize(long maximumUploadSize) {
        this.propertySupport.setPropertyLong("maximumUploadSize", maximumUploadSize);
    }

    @Override
    public long getMaximumUploadSize() {
        return this.propertySupport.getPropertyLong("maximumUploadSize");
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public String getFileName() {
        BinaryResource value = (BinaryResource)this.getValue();
        if (value != null) {
            return value.getFilename();
        }
        return null;
    }

    @Override
    public int getFileSize() {
        BinaryResource value = (BinaryResource)this.getValue();
        if (value != null) {
            return value.getContentLength();
        }
        return 0;
    }

    @Override
    protected IFileChooserButtonExtension<? extends AbstractFileChooserButton> createLocalExtension() {
        return new LocalFileChooserButtonExtension<AbstractFileChooserButton>(this);
    }

    protected static class LocalFileChooserButtonExtension<OWNER extends AbstractFileChooserButton>
    extends AbstractValueField.LocalValueFieldExtension<BinaryResource, OWNER>
    implements IFileChooserButtonExtension<OWNER> {
        public LocalFileChooserButtonExtension(OWNER owner) {
            super(owner);
        }
    }
}

