/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.colorfield;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.colorfield.IColorFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractBasicField;
import org.eclipse.scout.rt.client.ui.form.fields.IBasicFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.colorfield.IColorField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.ColorUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ClassId(value="1411a921-017a-4d64-b898-9ab01b9fa73a")
public abstract class AbstractColorField
extends AbstractBasicField<String>
implements IColorField {
    private IBasicFieldUIFacade m_uiFacade;
    protected static final Pattern RGB_COLOR_PATTERN = Pattern.compile("^([0-9]{1,3})[\\-\\,\\;\\/\\\\\\s]{1}([0-9]{1,3})[\\-\\,\\;\\/\\\\\\s]{1}([0-9]{1,3})$");

    public AbstractColorField() {
        this(true);
    }

    public AbstractColorField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new AbstractBasicField.P_UIFacade(this), ModelContextProxy.ModelContext.copyCurrent());
    }

    @Override
    public IBasicFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String parseValueInternal(String text) {
        if (StringUtility.isNullOrEmpty((CharSequence)text)) {
            return null;
        }
        try {
            Matcher matcher = ColorUtility.HEX_COLOR_PATTERN.matcher(text);
            if (matcher.matches()) {
                return "#" + matcher.group(2);
            }
            matcher = RGB_COLOR_PATTERN.matcher(text);
            if (matcher.matches()) {
                int r = Integer.parseInt(matcher.group(1));
                int g = Integer.parseInt(matcher.group(2));
                int b = Integer.parseInt(matcher.group(3));
                if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                    throw new ProcessingException(TEXTS.get((String)"InvalidValueMessageX", (String[])new String[]{text}), new Object[0]);
                }
                String hexValue = ColorUtility.rgbToText((int)r, (int)g, (int)b).toUpperCase();
                return hexValue;
            }
        }
        catch (Exception e) {
            throw new ProcessingException(TEXTS.get((String)"InvalidValueMessageX", (String[])new String[]{text}), new Object[]{e});
        }
        throw new ProcessingException(TEXTS.get((String)"InvalidValueMessageX", (String[])new String[]{text}), new Object[0]);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    protected IColorFieldExtension<? extends AbstractColorField> createLocalExtension() {
        return new LocalColorFieldExtension<AbstractColorField>(this);
    }

    protected static class LocalColorFieldExtension<OWNER extends AbstractColorField>
    extends AbstractBasicField.LocalBasicFieldExtension<String, OWNER>
    implements IColorFieldExtension<OWNER> {
        public LocalColorFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

