/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.calendarfield;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.form.fields.calendarfield.ICalendarFieldExtension;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="0b1ac83b-6fa4-4e12-88d0-680ed168e914")
public abstract class AbstractCalendarField<T extends ICalendar>
extends AbstractValueField<Date>
implements ICalendarField<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCalendarField.class);
    private T m_calendar;
    private final OptimisticLock m_valueSelectionMediator = new OptimisticLock();

    public AbstractCalendarField() {
        this(true);
    }

    public AbstractCalendarField(boolean callInitializer) {
        super(false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    private Class<? extends ICalendar> getConfiguredCalendar() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, ICalendar.class);
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected int getConfiguredGridH() {
        return UserAgentUtility.isMobileDevice() ? 11 : 9;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        List contributedCalendars = this.m_contributionHolder.getContributionsByClass(ICalendar.class);
        this.m_calendar = (ICalendar)CollectionUtility.firstElement((List)contributedCalendars);
        if (this.m_calendar == null) {
            Class<ICalendar> configuredCalendar = this.getConfiguredCalendar();
            this.m_calendar = (ICalendar)ConfigurationUtility.newInnerInstance((Object)this, configuredCalendar);
        }
        if (this.m_calendar != null) {
            this.m_calendar.setParentInternal(this);
            ClientUIPreferences env = ClientUIPreferences.getInstance();
            this.m_calendar.setDisplayMode(env.getCalendarDisplayMode(3));
            this.m_calendar.setDisplayCondensed(env.getCalendarDisplayCondensed(true));
            this.m_calendar.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("selectedDate")) {
                    this.syncCalendarToCalendarField();
                }
            });
            this.syncCalendarToCalendarField();
        } else {
            LOG.warn("there is no inner class of type ICalendar in {}", (Object)this.getClass().getName());
        }
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getCalendar())});
    }

    @Override
    protected void disposeFieldInternal() {
        ClientUIPreferences.getInstance().setCalendarPreferences(this.getCalendar().getDisplayMode(), this.getCalendar().isDisplayCondensed());
        super.disposeFieldInternal();
    }

    @Override
    public final T getCalendar() {
        return this.m_calendar;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) {
        this.setValue(null);
        this.getCalendar().reloadCalendarItems();
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncCalendarFieldToCalendar();
    }

    private void syncCalendarFieldToCalendar() {
        try {
            if (this.m_valueSelectionMediator.acquire()) {
                Date value = (Date)this.getValue();
                T cal = this.getCalendar();
                cal.setSelectedDate(value);
            }
        }
        finally {
            this.m_valueSelectionMediator.release();
        }
    }

    private void syncCalendarToCalendarField() {
        try {
            if (this.m_valueSelectionMediator.acquire()) {
                T cal = this.getCalendar();
                Date value = cal.getSelectedDate();
                this.setValue(value);
            }
        }
        finally {
            this.m_valueSelectionMediator.release();
        }
    }

    @Override
    public void reloadCalendarItems() {
        this.getCalendar().reloadCalendarItems();
    }

    @Override
    protected ICalendarFieldExtension<T, ? extends AbstractCalendarField<T>> createLocalExtension() {
        return new LocalCalendarFieldExtension(this);
    }

    protected static class LocalCalendarFieldExtension<T extends ICalendar, OWNER extends AbstractCalendarField<T>>
    extends AbstractValueField.LocalValueFieldExtension<Date, OWNER>
    implements ICalendarFieldExtension<T, OWNER> {
        public LocalCalendarFieldExtension(OWNER owner) {
            super(owner);
        }
    }
}

