/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.button;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class ButtonEvent
extends EventObject
implements IModelEvent {
    public static final int TYPE_CLICKED = 1;
    public static final int TYPE_REQUEST_POPUP = 4;
    private final int m_type;
    private List<IMenu> m_popupMenuList;

    public ButtonEvent(IButton source, int type) {
        super(source);
        this.m_type = type;
    }

    public IButton getButton() {
        return (IButton)super.getSource();
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public void addPopupMenus(List<IMenu> menus) {
        if (menus == null || menus.isEmpty()) {
            return;
        }
        if (this.m_popupMenuList == null) {
            this.m_popupMenuList = new ArrayList<IMenu>(menus.size());
        }
        this.m_popupMenuList.addAll(menus);
    }

    public void addPopupMenu(IMenu menu) {
        if (menu == null) {
            return;
        }
        if (this.m_popupMenuList == null) {
            this.m_popupMenuList = new ArrayList<IMenu>();
        }
        this.m_popupMenuList.add(menu);
    }

    public List<IMenu> getPopupMenus() {
        return CollectionUtility.arrayList(this.m_popupMenuList);
    }
}

