/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.browserfield;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.dto.FormData;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.browserfield.BrowserFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.browserfield.IBrowserFieldExtension;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.BrowserFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.BrowserFieldListener;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserField;
import org.eclipse.scout.rt.client.ui.form.fields.browserfield.IBrowserFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.browserfield.AbstractBrowserFieldData;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="6402e68c-abd1-42b8-8da2-b4a12f910c98")
@FormData(value=AbstractBrowserFieldData.class, defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.CREATE, sdkCommand=FormData.SdkCommand.USE)
public abstract class AbstractBrowserField
extends AbstractFormField
implements IBrowserField {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBrowserField.class);
    private IBrowserFieldUIFacade m_uiFacade;
    private final FastListenerList<BrowserFieldListener> m_listenerList = new FastListenerList();

    public AbstractBrowserField() {
        this(true);
    }

    public AbstractBrowserField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @Order(value=220.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredSandboxEnabled() {
        return true;
    }

    @Order(value=220.0)
    @ConfigProperty(value="OBJECT")
    protected EnumSet<IBrowserField.SandboxPermission> getConfiguredSandboxPermissions() {
        return null;
    }

    protected List<String> getConfiguredTrustedMessageOrigins() {
        return Collections.emptyList();
    }

    @Order(value=230.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredShowInExternalWindow() {
        return false;
    }

    @Order(value=230.0)
    @ConfigProperty(value="STRING")
    protected String getConfiguredExternalWindowFieldText() {
        return TEXTS.get((String)"ExternalWindowFieldText");
    }

    @Order(value=230.0)
    @ConfigProperty(value="STRING")
    protected String getConfiguredExternalWindowButtonText() {
        return TEXTS.get((String)"ExternalWindowButtonText");
    }

    @Order(value=230.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoCloseExternalWindow() {
        return false;
    }

    @Order(value=240.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredTrackLocation() {
        return false;
    }

    @ConfigOperation
    @Order(value=261.0)
    protected void execPostMessage(Object data, String origin) {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execExternalWindowStateChanged(boolean windowState) {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setScrollBarEnabled(this.getConfiguredScrollBarEnabled());
        this.setSandboxEnabled(this.getConfiguredSandboxEnabled());
        this.setSandboxPermissions(this.getConfiguredSandboxPermissions());
        this.setTrustedMessageOrigins(this.getConfiguredTrustedMessageOrigins());
        this.setShowInExternalWindow(this.getConfiguredShowInExternalWindow());
        this.setExternalWindowButtonText(this.getConfiguredExternalWindowButtonText());
        this.setExternalWindowFieldText(this.getConfiguredExternalWindowFieldText());
        this.setAutoCloseExternalWindow(this.getConfiguredAutoCloseExternalWindow());
        this.setTrackLocation(this.getConfiguredTrackLocation());
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) {
        Assertions.assertNotNull((Object)source);
        AbstractBrowserFieldData fd = (AbstractBrowserFieldData)source;
        if (source.isValueSet()) {
            try {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(false);
                }
                this.setLocationInternal(fd.getLocation());
                this.setBinaryResourceInternal(fd.getBinaryResource());
                this.setAttachmentsInternal(fd.getAttachments());
                this.fireContentChanged();
            }
            finally {
                if (!valueChangeTriggersEnabled) {
                    this.setValueChangeTriggerEnabled(true);
                }
            }
        }
    }

    @Override
    protected void applySearchInternal(SearchFilter search) {
    }

    @Override
    public IBrowserFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public IFastListenerList<BrowserFieldListener> browserFieldListeners() {
        return this.m_listenerList;
    }

    protected void fireContentChanged() {
        this.fireBrowserFieldEvent(new BrowserFieldEvent(this, 900));
    }

    protected void fireBrowserFieldEvent(BrowserFieldEvent e) {
        this.browserFieldListeners().list().forEach(listener -> listener.browserFieldChanged(e));
    }

    @Override
    public void setLocation(String location) {
        this.setLocationInternal(location);
        this.setBinaryResourceInternal(null);
        this.setAttachmentsInternal(null);
        this.fireContentChanged();
    }

    protected void setLocationInternal(String location) {
        this.validateLocation(location);
        this.propertySupport.setProperty("location", (Object)location);
    }

    protected void validateLocation(String location) {
        try {
            if (location == null) {
                return;
            }
            URI uri = new URI(location);
            if (uri.getScheme() == null && !location.startsWith("//")) {
                throw new IllegalArgumentException("Missing scheme in URI: " + location);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + location, e);
        }
    }

    @Override
    public String getLocation() {
        return this.propertySupport.getPropertyString("location");
    }

    @Override
    public void setBinaryResource(BinaryResource binaryResource) {
        this.setLocationInternal(null);
        this.setBinaryResourceInternal(binaryResource);
        this.fireContentChanged();
    }

    @Override
    public void setBinaryResource(BinaryResource binaryResource, BinaryResource ... attachments) {
        this.setLocationInternal(null);
        this.setBinaryResourceInternal(binaryResource);
        if (attachments == null) {
            this.setAttachmentsInternal(null);
        } else {
            HashSet<BinaryResource> attachmentSet = new HashSet<BinaryResource>();
            BinaryResource[] binaryResourceArray = attachments;
            int n = attachments.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryResource attachment = binaryResourceArray[n2];
                if (attachment != null) {
                    attachmentSet.add(attachment);
                }
                ++n2;
            }
            this.setAttachmentsInternal(attachmentSet);
        }
        this.fireContentChanged();
    }

    protected void setBinaryResourceInternal(BinaryResource binaryResource) {
        this.propertySupport.setProperty("binaryResource", (Object)binaryResource);
    }

    @Override
    public BinaryResource getBinaryResource() {
        return (BinaryResource)this.propertySupport.getProperty("binaryResource");
    }

    @Override
    public void setAttachments(Set<BinaryResource> attachments) {
        this.setAttachmentsInternal(attachments);
    }

    protected void setAttachmentsInternal(Set<BinaryResource> attachments) {
        this.propertySupport.setProperty("attachments", attachments);
    }

    @Override
    public Set<BinaryResource> getAttachments() {
        return (Set)this.propertySupport.getProperty("attachments");
    }

    protected void firePostMessage(Object message, String targetOrigin) {
        this.fireBrowserFieldEvent(new BrowserFieldEvent(this, 901).withMessage(message).withTargetOrigin(targetOrigin));
    }

    @Override
    public void postMessage(Object message, String targetOrigin) {
        this.firePostMessage(message, targetOrigin);
    }

    @Override
    public void setScrollBarEnabled(boolean scrollBarEnabled) {
        this.propertySupport.setProperty("scrollBarEnabled", (Object)scrollBarEnabled);
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.propertySupport.getPropertyBool("scrollBarEnabled");
    }

    protected BinaryResource resolveBinaryResource(String filename) {
        if (filename == null) {
            return null;
        }
        BinaryResource binaryResource = this.getBinaryResource();
        if (binaryResource != null && ObjectUtility.equals((Object)binaryResource.getFilename(), (Object)filename)) {
            return binaryResource;
        }
        Set<BinaryResource> attachments = this.getAttachments();
        if (attachments != null) {
            for (BinaryResource attachment : attachments) {
                if (!ObjectUtility.equals((Object)attachment.getFilename(), (Object)filename)) continue;
                return attachment;
            }
        }
        LOG.warn("Could not resolve binary resource for filename: {}. Origin: {}", (Object)filename, this.getClass());
        return null;
    }

    @Override
    public void setSandboxEnabled(boolean sandboxEnabled) {
        this.propertySupport.setProperty("sandboxEnabled", (Object)sandboxEnabled);
    }

    @Override
    public boolean isSandboxEnabled() {
        return this.propertySupport.getPropertyBool("sandboxEnabled");
    }

    @Override
    public void setSandboxPermissions(EnumSet<IBrowserField.SandboxPermission> sandboxPermission) {
        this.propertySupport.setProperty("sandboxPermissions", sandboxPermission);
    }

    @Override
    public List<String> getTrustedMessageOrigins() {
        return this.propertySupport.getPropertyList("trustedMessageOrigins");
    }

    @Override
    public void setTrustedMessageOrigins(List<String> trustedMessageOrigins) {
        this.propertySupport.setPropertyList("trustedMessageOrigins", trustedMessageOrigins);
    }

    @Override
    public EnumSet<IBrowserField.SandboxPermission> getSandboxPermissions() {
        return (EnumSet)this.propertySupport.getProperty("sandboxPermissions");
    }

    @Override
    public void setShowInExternalWindow(boolean showInExternalWindow) {
        this.propertySupport.setPropertyBool("showInExternalWindow", showInExternalWindow);
    }

    @Override
    public boolean isShowInExternalWindow() {
        return this.propertySupport.getPropertyBool("showInExternalWindow");
    }

    @Override
    public void setExternalWindowButtonText(String externalWindowButtonText) {
        this.propertySupport.setPropertyString("externalWindowButtonText", externalWindowButtonText);
    }

    @Override
    public String getExternalWindowButtonText() {
        return this.propertySupport.getPropertyString("externalWindowButtonText");
    }

    @Override
    public void setExternalWindowFieldText(String externalWindowFieldText) {
        this.propertySupport.setPropertyString("externalWindowFieldText", externalWindowFieldText);
    }

    @Override
    public String getExternalWindowFieldText() {
        return this.propertySupport.getPropertyString("externalWindowFieldText");
    }

    @Override
    public boolean isAutoCloseExternalWindow() {
        return this.propertySupport.getPropertyBool("autoCloseExternalWindow");
    }

    @Override
    public void setAutoCloseExternalWindow(boolean autoCloseExternalWindow) {
        this.propertySupport.setPropertyBool("autoCloseExternalWindow", autoCloseExternalWindow);
    }

    @Override
    public boolean isTrackLocation() {
        return this.propertySupport.getPropertyBool("trackLocation");
    }

    @Override
    public void setTrackLocation(boolean trackLocation) {
        this.propertySupport.setPropertyBool("trackLocation", trackLocation);
    }

    protected final void interceptPostMessage(Object data, String origin) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        BrowserFieldChains.BrowserFieldPostMessageChain chain = new BrowserFieldChains.BrowserFieldPostMessageChain(extensions);
        chain.execPostMessage(data, origin);
    }

    protected final void interceptExternalWindowStateChanged(boolean state) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        BrowserFieldChains.BrowserFieldExternalWindowStateChangedChain chain = new BrowserFieldChains.BrowserFieldExternalWindowStateChangedChain(extensions);
        chain.execExternalWindowStateChanged(state);
    }

    protected IBrowserFieldExtension<? extends AbstractBrowserField> createLocalExtension() {
        return new LocalBrowserFieldExtension<AbstractBrowserField>(this);
    }

    protected static class LocalBrowserFieldExtension<OWNER extends AbstractBrowserField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IBrowserFieldExtension<OWNER> {
        public LocalBrowserFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execPostMessage(BrowserFieldChains.BrowserFieldPostMessageChain chain, Object data, String origin) {
            ((AbstractBrowserField)this.getOwner()).execPostMessage(data, origin);
        }

        @Override
        public void execExternalWindowStateChanged(BrowserFieldChains.BrowserFieldExternalWindowStateChangedChain chain, boolean state) {
            ((AbstractBrowserField)this.getOwner()).execExternalWindowStateChanged(state);
        }
    }

    protected class P_UIFacade
    implements IBrowserFieldUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void firePostExternalWindowStateFromUI(boolean state) {
            AbstractBrowserField.this.interceptExternalWindowStateChanged(state);
        }

        @Override
        public void firePostMessageFromUI(Object data, String origin) {
            if (!AbstractBrowserField.this.isEnabledIncludingParents() || !AbstractBrowserField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractBrowserField.this.interceptPostMessage(data, origin);
        }

        @Override
        public BinaryResource requestBinaryResourceFromUI(String filename) {
            return AbstractBrowserField.this.resolveBinaryResource(filename);
        }

        @Override
        public void setLocationFromUI(String location) {
            AbstractBrowserField.this.setLocation(location);
        }
    }
}

