/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.accordionfield;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.accordionfield.AccordionFieldChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.accordionfield.IAccordionFieldExtension;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.accordion.IAccordion;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.accordionfield.IAccordionField;
import org.eclipse.scout.rt.client.ui.form.fields.accordionfield.IAccordionFieldUIFacade;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="2ede595d-acc7-43ef-bda7-288cc5fcdc91")
public abstract class AbstractAccordionField<T extends IAccordion>
extends AbstractFormField
implements IAccordionField<T> {
    private IAccordionFieldUIFacade<T> m_uiFacade;

    public AbstractAccordionField() {
        this(true);
    }

    public AbstractAccordionField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        super.initConfig();
        this.setAccordion(this.createAccordion());
        this.setDropMaximumSize(this.getConfiguredDropMaximumSize());
        this.setDropType(this.getConfiguredDropType());
        this.setDragType(this.getConfiguredDragType());
    }

    protected T createAccordion() {
        List contributedFields = this.m_contributionHolder.getContributionsByClass(IAccordion.class);
        IAccordion result = (IAccordion)CollectionUtility.firstElement((List)contributedFields);
        if (result != null) {
            return (T)result;
        }
        Class<IAccordion> configuredAccordion = this.getConfiguredAccordion();
        if (configuredAccordion != null) {
            return (T)((IAccordion)ConfigurationUtility.newInnerInstance((Object)this, configuredAccordion));
        }
        return null;
    }

    private Class<? extends IAccordion> getConfiguredAccordion() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClass((Class[])dca, IAccordion.class);
    }

    @ConfigProperty(value="LONG")
    @Order(value=10.0)
    protected long getConfiguredDropMaximumSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=20.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=30.0)
    protected int getConfiguredDragType() {
        return 0;
    }

    @Override
    public T getAccordion() {
        return (T)((IAccordion)this.propertySupport.getProperty("accordion"));
    }

    @Override
    public void setAccordion(T accordion) {
        T oldAccordion = this.getAccordion();
        if (oldAccordion == accordion) {
            return;
        }
        if (oldAccordion != null) {
            oldAccordion.setParentInternal(null);
        }
        this.propertySupport.setProperty("accordion", accordion);
        if (accordion != null) {
            accordion.setParentInternal(this);
        }
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.propertySupport.setPropertyLong("dropMaximumSize", dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.propertySupport.getPropertyInt("dropMaximumSize");
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), Collections.singletonList(this.getAccordion())});
    }

    @Override
    protected int getConfiguredGridH() {
        return 3;
    }

    @Override
    protected boolean execIsEmpty() {
        if (!super.execIsEmpty()) {
            return false;
        }
        return this.getAccordion().getGroups().isEmpty();
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDropRequest(TransferObject transferObject) {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected TransferObject execDragRequest() {
        return null;
    }

    @Override
    public IAccordionFieldUIFacade<T> getUIFacade() {
        return this.m_uiFacade;
    }

    protected IAccordionFieldExtension<T, ? extends AbstractAccordionField> createLocalExtension() {
        return new LocalAccordionFieldExtension(this);
    }

    protected final TransferObject interceptDragRequest() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        AccordionFieldChains.AccordionFieldDragRequestChain chain = new AccordionFieldChains.AccordionFieldDragRequestChain(extensions);
        return chain.execDragRequest();
    }

    protected final void interceptDropRequest(TransferObject transferObject) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        AccordionFieldChains.AccordionFieldDropRequestChain chain = new AccordionFieldChains.AccordionFieldDropRequestChain(extensions);
        chain.execDropRequest(transferObject);
    }

    protected static class LocalAccordionFieldExtension<T extends IAccordion, OWNER extends AbstractAccordionField<T>>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements IAccordionFieldExtension<T, OWNER> {
        public LocalAccordionFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public TransferObject execDragRequest(AccordionFieldChains.AccordionFieldDragRequestChain chain) {
            return ((AbstractAccordionField)this.getOwner()).execDragRequest();
        }

        @Override
        public void execDropRequest(AccordionFieldChains.AccordionFieldDropRequestChain chain, TransferObject transferObject) {
            ((AbstractAccordionField)this.getOwner()).execDropRequest(transferObject);
        }
    }

    protected class P_UIFacade
    implements IAccordionFieldUIFacade<T> {
        protected P_UIFacade() {
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            TransferObject t = null;
            t = AbstractAccordionField.this.interceptDragRequest();
            return t;
        }

        @Override
        public void fireDropActionFromUI(TransferObject scoutTransferable) {
            if (!AbstractAccordionField.this.isEnabledIncludingParents() || !AbstractAccordionField.this.isVisibleIncludingParents()) {
                return;
            }
            AbstractAccordionField.this.interceptDropRequest(scoutTransferable);
        }
    }
}

